/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.retry.AwsRetryPolicy;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.retry.RetryPolicy;
import software.amazon.awssdk.core.retry.RetryPolicyContext;
import software.amazon.awssdk.core.retry.conditions.AndRetryCondition;
import software.amazon.awssdk.core.retry.conditions.RetryCondition;
import software.amazon.awssdk.profiles.ProfileFile;
import software.amazon.awssdk.services.kinesis.model.SubscribeToShardRequest;

@SdkInternalApi
final class KinesisRetryPolicy {
    private KinesisRetryPolicy() {
    }

    public static RetryPolicy resolveRetryPolicy(SdkClientConfiguration config) {
        RetryPolicy configuredRetryPolicy = (RetryPolicy)config.option((ClientOption)SdkClientOption.RETRY_POLICY);
        if (configuredRetryPolicy != null) {
            return KinesisRetryPolicy.addRetryConditions(configuredRetryPolicy);
        }
        RetryMode retryMode = RetryMode.resolver().profileFile(() -> (ProfileFile)config.option((ClientOption)SdkClientOption.PROFILE_FILE)).profileName((String)config.option((ClientOption)SdkClientOption.PROFILE_NAME)).defaultRetryMode((RetryMode)config.option((ClientOption)SdkClientOption.DEFAULT_RETRY_MODE)).resolve();
        return ((RetryPolicy.Builder)AwsRetryPolicy.forRetryMode((RetryMode)retryMode).toBuilder().applyMutation(KinesisRetryPolicy::addRetryConditions)).additionalRetryConditionsAllowed(false).build();
    }

    public static RetryPolicy addRetryConditions(RetryPolicy policy) {
        if (!policy.additionalRetryConditionsAllowed()) {
            return policy;
        }
        return ((RetryPolicy.Builder)policy.toBuilder().applyMutation(KinesisRetryPolicy::addRetryConditions)).build();
    }

    public static void addRetryConditions(RetryPolicy.Builder policy) {
        policy.retryCondition((RetryCondition)AndRetryCondition.create((RetryCondition[])new RetryCondition[]{KinesisRetryPolicy::isNotSubscribeToShard, policy.retryCondition()}));
    }

    private static boolean isNotSubscribeToShard(RetryPolicyContext context) {
        return !(context.originalRequest() instanceof SubscribeToShardRequest);
    }
}

