/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ShardIteratorType {
    AT_SEQUENCE_NUMBER("AT_SEQUENCE_NUMBER"),
    AFTER_SEQUENCE_NUMBER("AFTER_SEQUENCE_NUMBER"),
    TRIM_HORIZON("TRIM_HORIZON"),
    LATEST("LATEST"),
    AT_TIMESTAMP("AT_TIMESTAMP"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ShardIteratorType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ShardIteratorType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ShardIteratorType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ShardIteratorType> knownValues() {
        return Stream.of(ShardIteratorType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

