/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.retry.AwsRetryPolicy;
import software.amazon.awssdk.core.retry.RetryPolicy;
import software.amazon.awssdk.core.retry.RetryPolicyContext;
import software.amazon.awssdk.core.retry.conditions.AndRetryCondition;
import software.amazon.awssdk.core.retry.conditions.RetryCondition;
import software.amazon.awssdk.services.kinesis.model.SubscribeToShardRequest;

@SdkInternalApi
final class KinesisRetryPolicy {
    private KinesisRetryPolicy() {
    }

    public static RetryPolicy defaultRetryPolicy() {
        return AwsRetryPolicy.defaultRetryPolicy().toBuilder().retryCondition((RetryCondition)AndRetryCondition.create((RetryCondition[])new RetryCondition[]{KinesisRetryPolicy::isNotSubscribeToShard, AwsRetryPolicy.defaultRetryCondition()})).additionalRetryConditionsAllowed(false).build();
    }

    public static RetryPolicy addRetryConditions(RetryPolicy policy) {
        if (!policy.additionalRetryConditionsAllowed()) {
            return policy;
        }
        return policy.toBuilder().retryCondition((RetryCondition)AndRetryCondition.create((RetryCondition[])new RetryCondition[]{KinesisRetryPolicy::isNotSubscribeToShard, policy.retryCondition()})).build();
    }

    private static boolean isNotSubscribeToShard(RetryPolicyContext context) {
        return !(context.originalRequest() instanceof SubscribeToShardRequest);
    }
}

