/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.kinesis.model.ConsumerDescription;

public class ConsumerDescriptionUnmarshaller
implements Unmarshaller<ConsumerDescription, JsonUnmarshallerContext> {
    private static final ConsumerDescriptionUnmarshaller INSTANCE = new ConsumerDescriptionUnmarshaller();

    public ConsumerDescription unmarshall(JsonUnmarshallerContext context) throws Exception {
        ConsumerDescription.Builder consumerDescriptionBuilder = ConsumerDescription.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("ConsumerName", targetDepth)) {
                    context.nextToken();
                    consumerDescriptionBuilder.consumerName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ConsumerARN", targetDepth)) {
                    context.nextToken();
                    consumerDescriptionBuilder.consumerARN((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ConsumerStatus", targetDepth)) {
                    context.nextToken();
                    consumerDescriptionBuilder.consumerStatus((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ConsumerCreationTimestamp", targetDepth)) {
                    context.nextToken();
                    consumerDescriptionBuilder.consumerCreationTimestamp((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("StreamARN", targetDepth)) {
                    context.nextToken();
                    consumerDescriptionBuilder.streamARN((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ConsumerDescription)consumerDescriptionBuilder.build();
    }

    public static ConsumerDescriptionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

