/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesis.model.ConsumerDescription;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ConsumerDescriptionMarshaller {
    private static final MarshallingInfo<String> CONSUMERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConsumerName").isBinary(false).build();
    private static final MarshallingInfo<String> CONSUMERARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConsumerARN").isBinary(false).build();
    private static final MarshallingInfo<String> CONSUMERSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConsumerStatus").isBinary(false).build();
    private static final MarshallingInfo<Instant> CONSUMERCREATIONTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConsumerCreationTimestamp").isBinary(false).build();
    private static final MarshallingInfo<String> STREAMARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamARN").isBinary(false).build();
    private static final ConsumerDescriptionMarshaller INSTANCE = new ConsumerDescriptionMarshaller();

    private ConsumerDescriptionMarshaller() {
    }

    public static ConsumerDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ConsumerDescription consumerDescription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)consumerDescription, (String)"consumerDescription");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)consumerDescription.consumerName(), CONSUMERNAME_BINDING);
            protocolMarshaller.marshall((Object)consumerDescription.consumerARN(), CONSUMERARN_BINDING);
            protocolMarshaller.marshall((Object)consumerDescription.consumerStatusAsString(), CONSUMERSTATUS_BINDING);
            protocolMarshaller.marshall((Object)consumerDescription.consumerCreationTimestamp(), CONSUMERCREATIONTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)consumerDescription.streamARN(), STREAMARN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

