/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.kinesis.model.KinesisRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterStreamConsumerRequest
extends KinesisRequest
implements ToCopyableBuilder<Builder, RegisterStreamConsumerRequest> {
    private final String streamARN;
    private final String consumerName;

    private RegisterStreamConsumerRequest(BuilderImpl builder) {
        super(builder);
        this.streamARN = builder.streamARN;
        this.consumerName = builder.consumerName;
    }

    public String streamARN() {
        return this.streamARN;
    }

    public String consumerName() {
        return this.consumerName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.streamARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.consumerName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterStreamConsumerRequest)) {
            return false;
        }
        RegisterStreamConsumerRequest other = (RegisterStreamConsumerRequest)((Object)obj);
        return Objects.equals(this.streamARN(), other.streamARN()) && Objects.equals(this.consumerName(), other.consumerName());
    }

    public String toString() {
        return ToString.builder((String)"RegisterStreamConsumerRequest").add("StreamARN", (Object)this.streamARN()).add("ConsumerName", (Object)this.consumerName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamARN": {
                return Optional.ofNullable(clazz.cast(this.streamARN()));
            }
            case "ConsumerName": {
                return Optional.ofNullable(clazz.cast(this.consumerName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends KinesisRequest.BuilderImpl
    implements Builder {
        private String streamARN;
        private String consumerName;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterStreamConsumerRequest model) {
            super(model);
            this.streamARN(model.streamARN);
            this.consumerName(model.consumerName);
        }

        public final String getStreamARN() {
            return this.streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        public final String getConsumerName() {
            return this.consumerName;
        }

        @Override
        public final Builder consumerName(String consumerName) {
            this.consumerName = consumerName;
            return this;
        }

        public final void setConsumerName(String consumerName) {
            this.consumerName = consumerName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterStreamConsumerRequest build() {
            return new RegisterStreamConsumerRequest(this);
        }
    }

    public static interface Builder
    extends KinesisRequest.Builder,
    CopyableBuilder<Builder, RegisterStreamConsumerRequest> {
        public Builder streamARN(String var1);

        public Builder consumerName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

