/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesis.transform.PutRecordsRequestEntryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutRecordsRequestEntry
implements StructuredPojo,
ToCopyableBuilder<Builder, PutRecordsRequestEntry> {
    private final SdkBytes data;
    private final String explicitHashKey;
    private final String partitionKey;

    private PutRecordsRequestEntry(BuilderImpl builder) {
        this.data = builder.data;
        this.explicitHashKey = builder.explicitHashKey;
        this.partitionKey = builder.partitionKey;
    }

    public SdkBytes data() {
        return this.data;
    }

    public String explicitHashKey() {
        return this.explicitHashKey;
    }

    public String partitionKey() {
        return this.partitionKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.data());
        hashCode = 31 * hashCode + Objects.hashCode(this.explicitHashKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.partitionKey());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRecordsRequestEntry)) {
            return false;
        }
        PutRecordsRequestEntry other = (PutRecordsRequestEntry)obj;
        return Objects.equals(this.data(), other.data()) && Objects.equals(this.explicitHashKey(), other.explicitHashKey()) && Objects.equals(this.partitionKey(), other.partitionKey());
    }

    public String toString() {
        return ToString.builder((String)"PutRecordsRequestEntry").add("Data", (Object)this.data()).add("ExplicitHashKey", (Object)this.explicitHashKey()).add("PartitionKey", (Object)this.partitionKey()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Data": {
                return Optional.ofNullable(clazz.cast(this.data()));
            }
            case "ExplicitHashKey": {
                return Optional.ofNullable(clazz.cast(this.explicitHashKey()));
            }
            case "PartitionKey": {
                return Optional.ofNullable(clazz.cast(this.partitionKey()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PutRecordsRequestEntryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private SdkBytes data;
        private String explicitHashKey;
        private String partitionKey;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRecordsRequestEntry model) {
            this.data(model.data);
            this.explicitHashKey(model.explicitHashKey);
            this.partitionKey(model.partitionKey);
        }

        public final ByteBuffer getData() {
            return this.data == null ? null : this.data.asByteBuffer();
        }

        @Override
        public final Builder data(SdkBytes data) {
            this.data = StandardMemberCopier.copy((SdkBytes)data);
            return this;
        }

        public final void setData(ByteBuffer data) {
            this.data(data == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)data));
        }

        public final String getExplicitHashKey() {
            return this.explicitHashKey;
        }

        @Override
        public final Builder explicitHashKey(String explicitHashKey) {
            this.explicitHashKey = explicitHashKey;
            return this;
        }

        public final void setExplicitHashKey(String explicitHashKey) {
            this.explicitHashKey = explicitHashKey;
        }

        public final String getPartitionKey() {
            return this.partitionKey;
        }

        @Override
        public final Builder partitionKey(String partitionKey) {
            this.partitionKey = partitionKey;
            return this;
        }

        public final void setPartitionKey(String partitionKey) {
            this.partitionKey = partitionKey;
        }

        public PutRecordsRequestEntry build() {
            return new PutRecordsRequestEntry(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutRecordsRequestEntry> {
        public Builder data(SdkBytes var1);

        public Builder explicitHashKey(String var1);

        public Builder partitionKey(String var1);
    }
}

