/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.kinesis.model.KinesisRequest;
import software.amazon.awssdk.services.kinesis.model.ScalingType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateShardCountRequest
extends KinesisRequest
implements ToCopyableBuilder<Builder, UpdateShardCountRequest> {
    private final String streamName;
    private final Integer targetShardCount;
    private final String scalingType;

    private UpdateShardCountRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.targetShardCount = builder.targetShardCount;
        this.scalingType = builder.scalingType;
    }

    public String streamName() {
        return this.streamName;
    }

    public Integer targetShardCount() {
        return this.targetShardCount;
    }

    public ScalingType scalingType() {
        return ScalingType.fromValue(this.scalingType);
    }

    public String scalingTypeAsString() {
        return this.scalingType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetShardCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateShardCountRequest)) {
            return false;
        }
        UpdateShardCountRequest other = (UpdateShardCountRequest)((Object)obj);
        return Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.targetShardCount(), other.targetShardCount()) && Objects.equals(this.scalingTypeAsString(), other.scalingTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"UpdateShardCountRequest").add("StreamName", (Object)this.streamName()).add("TargetShardCount", (Object)this.targetShardCount()).add("ScalingType", (Object)this.scalingTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamName": {
                return Optional.ofNullable(clazz.cast(this.streamName()));
            }
            case "TargetShardCount": {
                return Optional.ofNullable(clazz.cast(this.targetShardCount()));
            }
            case "ScalingType": {
                return Optional.ofNullable(clazz.cast(this.scalingTypeAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends KinesisRequest.BuilderImpl
    implements Builder {
        private String streamName;
        private Integer targetShardCount;
        private String scalingType;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateShardCountRequest model) {
            super(model);
            this.streamName(model.streamName);
            this.targetShardCount(model.targetShardCount);
            this.scalingType(model.scalingType);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final Integer getTargetShardCount() {
            return this.targetShardCount;
        }

        @Override
        public final Builder targetShardCount(Integer targetShardCount) {
            this.targetShardCount = targetShardCount;
            return this;
        }

        public final void setTargetShardCount(Integer targetShardCount) {
            this.targetShardCount = targetShardCount;
        }

        public final String getScalingType() {
            return this.scalingType;
        }

        @Override
        public final Builder scalingType(String scalingType) {
            this.scalingType = scalingType;
            return this;
        }

        @Override
        public final Builder scalingType(ScalingType scalingType) {
            this.scalingType(scalingType.toString());
            return this;
        }

        public final void setScalingType(String scalingType) {
            this.scalingType = scalingType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateShardCountRequest build() {
            return new UpdateShardCountRequest(this);
        }
    }

    public static interface Builder
    extends KinesisRequest.Builder,
    CopyableBuilder<Builder, UpdateShardCountRequest> {
        public Builder streamName(String var1);

        public Builder targetShardCount(Integer var1);

        public Builder scalingType(String var1);

        public Builder scalingType(ScalingType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

