/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesis.transform.SequenceNumberRangeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SequenceNumberRange
implements StructuredPojo,
ToCopyableBuilder<Builder, SequenceNumberRange> {
    private final String startingSequenceNumber;
    private final String endingSequenceNumber;

    private SequenceNumberRange(BuilderImpl builder) {
        this.startingSequenceNumber = builder.startingSequenceNumber;
        this.endingSequenceNumber = builder.endingSequenceNumber;
    }

    public String startingSequenceNumber() {
        return this.startingSequenceNumber;
    }

    public String endingSequenceNumber() {
        return this.endingSequenceNumber;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.startingSequenceNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.endingSequenceNumber());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SequenceNumberRange)) {
            return false;
        }
        SequenceNumberRange other = (SequenceNumberRange)obj;
        return Objects.equals(this.startingSequenceNumber(), other.startingSequenceNumber()) && Objects.equals(this.endingSequenceNumber(), other.endingSequenceNumber());
    }

    public String toString() {
        return ToString.builder((String)"SequenceNumberRange").add("StartingSequenceNumber", (Object)this.startingSequenceNumber()).add("EndingSequenceNumber", (Object)this.endingSequenceNumber()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StartingSequenceNumber": {
                return Optional.ofNullable(clazz.cast(this.startingSequenceNumber()));
            }
            case "EndingSequenceNumber": {
                return Optional.ofNullable(clazz.cast(this.endingSequenceNumber()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SequenceNumberRangeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String startingSequenceNumber;
        private String endingSequenceNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(SequenceNumberRange model) {
            this.startingSequenceNumber(model.startingSequenceNumber);
            this.endingSequenceNumber(model.endingSequenceNumber);
        }

        public final String getStartingSequenceNumber() {
            return this.startingSequenceNumber;
        }

        @Override
        public final Builder startingSequenceNumber(String startingSequenceNumber) {
            this.startingSequenceNumber = startingSequenceNumber;
            return this;
        }

        public final void setStartingSequenceNumber(String startingSequenceNumber) {
            this.startingSequenceNumber = startingSequenceNumber;
        }

        public final String getEndingSequenceNumber() {
            return this.endingSequenceNumber;
        }

        @Override
        public final Builder endingSequenceNumber(String endingSequenceNumber) {
            this.endingSequenceNumber = endingSequenceNumber;
            return this;
        }

        public final void setEndingSequenceNumber(String endingSequenceNumber) {
            this.endingSequenceNumber = endingSequenceNumber;
        }

        public SequenceNumberRange build() {
            return new SequenceNumberRange(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SequenceNumberRange> {
        public Builder startingSequenceNumber(String var1);

        public Builder endingSequenceNumber(String var1);
    }
}

