/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.kinesis.model.Consumer;
import software.amazon.awssdk.services.kinesis.model.ConsumerListCopier;
import software.amazon.awssdk.services.kinesis.model.KinesisResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListStreamConsumersResponse
extends KinesisResponse
implements ToCopyableBuilder<Builder, ListStreamConsumersResponse> {
    private final List<Consumer> consumers;
    private final String nextToken;

    private ListStreamConsumersResponse(BuilderImpl builder) {
        super(builder);
        this.consumers = builder.consumers;
        this.nextToken = builder.nextToken;
    }

    public List<Consumer> consumers() {
        return this.consumers;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.consumers());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStreamConsumersResponse)) {
            return false;
        }
        ListStreamConsumersResponse other = (ListStreamConsumersResponse)((Object)obj);
        return Objects.equals(this.consumers(), other.consumers()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListStreamConsumersResponse").add("Consumers", this.consumers()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Consumers": {
                return Optional.ofNullable(clazz.cast(this.consumers()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends KinesisResponse.BuilderImpl
    implements Builder {
        private List<Consumer> consumers = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStreamConsumersResponse model) {
            super(model);
            this.consumers(model.consumers);
            this.nextToken(model.nextToken);
        }

        public final Collection<Consumer.Builder> getConsumers() {
            return this.consumers != null ? (Collection)this.consumers.stream().map(Consumer::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder consumers(Collection<Consumer> consumers) {
            this.consumers = ConsumerListCopier.copy(consumers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder consumers(Consumer ... consumers) {
            this.consumers(Arrays.asList(consumers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder consumers(java.util.function.Consumer<Consumer.Builder> ... consumers) {
            this.consumers(Stream.of(consumers).map(c -> (Consumer)((Consumer.Builder)Consumer.builder().applyMutation((java.util.function.Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConsumers(Collection<Consumer.BuilderImpl> consumers) {
            this.consumers = ConsumerListCopier.copyFromBuilder(consumers);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListStreamConsumersResponse build() {
            return new ListStreamConsumersResponse(this);
        }
    }

    public static interface Builder
    extends KinesisResponse.Builder,
    CopyableBuilder<Builder, ListStreamConsumersResponse> {
        public Builder consumers(Collection<Consumer> var1);

        public Builder consumers(Consumer ... var1);

        public Builder consumers(java.util.function.Consumer<Consumer.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

