/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamConsumerRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DescribeStreamConsumerRequestModelMarshaller {
    private static final MarshallingInfo<String> STREAMARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamARN").isBinary(false).build();
    private static final MarshallingInfo<String> CONSUMERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConsumerName").isBinary(false).build();
    private static final MarshallingInfo<String> CONSUMERARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConsumerARN").isBinary(false).build();
    private static final DescribeStreamConsumerRequestModelMarshaller INSTANCE = new DescribeStreamConsumerRequestModelMarshaller();

    private DescribeStreamConsumerRequestModelMarshaller() {
    }

    public static DescribeStreamConsumerRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DescribeStreamConsumerRequest describeStreamConsumerRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)describeStreamConsumerRequest), (String)"describeStreamConsumerRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)describeStreamConsumerRequest.streamARN(), STREAMARN_BINDING);
            protocolMarshaller.marshall((Object)describeStreamConsumerRequest.consumerName(), CONSUMERNAME_BINDING);
            protocolMarshaller.marshall((Object)describeStreamConsumerRequest.consumerARN(), CONSUMERARN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

