/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesis.model.PutRecordRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PutRecordRequestModelMarshaller {
    private static final MarshallingInfo<String> STREAMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamName").isBinary(false).build();
    private static final MarshallingInfo<SdkBytes> DATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.SDK_BYTES).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Data").isBinary(false).build();
    private static final MarshallingInfo<String> PARTITIONKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PartitionKey").isBinary(false).build();
    private static final MarshallingInfo<String> EXPLICITHASHKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExplicitHashKey").isBinary(false).build();
    private static final MarshallingInfo<String> SEQUENCENUMBERFORORDERING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SequenceNumberForOrdering").isBinary(false).build();
    private static final PutRecordRequestModelMarshaller INSTANCE = new PutRecordRequestModelMarshaller();

    private PutRecordRequestModelMarshaller() {
    }

    public static PutRecordRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PutRecordRequest putRecordRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)putRecordRequest), (String)"putRecordRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)putRecordRequest.streamName(), STREAMNAME_BINDING);
            protocolMarshaller.marshall((Object)putRecordRequest.data(), DATA_BINDING);
            protocolMarshaller.marshall((Object)putRecordRequest.partitionKey(), PARTITIONKEY_BINDING);
            protocolMarshaller.marshall((Object)putRecordRequest.explicitHashKey(), EXPLICITHASHKEY_BINDING);
            protocolMarshaller.marshall((Object)putRecordRequest.sequenceNumberForOrdering(), SEQUENCENUMBERFORORDERING_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

