/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesisanalytics.model.S3ReferenceDataSource;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class S3ReferenceDataSourceMarshaller {
    private static final MarshallingInfo<String> BUCKETARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BucketARN").isBinary(false).build();
    private static final MarshallingInfo<String> FILEKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FileKey").isBinary(false).build();
    private static final MarshallingInfo<String> REFERENCEROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReferenceRoleARN").isBinary(false).build();
    private static final S3ReferenceDataSourceMarshaller INSTANCE = new S3ReferenceDataSourceMarshaller();

    private S3ReferenceDataSourceMarshaller() {
    }

    public static S3ReferenceDataSourceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(S3ReferenceDataSource s3ReferenceDataSource, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)s3ReferenceDataSource, (String)"s3ReferenceDataSource");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)s3ReferenceDataSource.bucketARN(), BUCKETARN_BINDING);
            protocolMarshaller.marshall((Object)s3ReferenceDataSource.fileKey(), FILEKEY_BINDING);
            protocolMarshaller.marshall((Object)s3ReferenceDataSource.referenceRoleARN(), REFERENCEROLEARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

