/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.model.RecordColumn;
import software.amazon.awssdk.services.kinesisanalytics.model.RecordColumnsCopier;
import software.amazon.awssdk.services.kinesisanalytics.model.RecordFormat;
import software.amazon.awssdk.services.kinesisanalytics.transform.SourceSchemaMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SourceSchema
implements StructuredPojo,
ToCopyableBuilder<Builder, SourceSchema> {
    private final RecordFormat recordFormat;
    private final String recordEncoding;
    private final List<RecordColumn> recordColumns;

    private SourceSchema(BuilderImpl builder) {
        this.recordFormat = builder.recordFormat;
        this.recordEncoding = builder.recordEncoding;
        this.recordColumns = builder.recordColumns;
    }

    public RecordFormat recordFormat() {
        return this.recordFormat;
    }

    public String recordEncoding() {
        return this.recordEncoding;
    }

    public List<RecordColumn> recordColumns() {
        return this.recordColumns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.recordFormat());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordEncoding());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordColumns());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceSchema)) {
            return false;
        }
        SourceSchema other = (SourceSchema)obj;
        return Objects.equals(this.recordFormat(), other.recordFormat()) && Objects.equals(this.recordEncoding(), other.recordEncoding()) && Objects.equals(this.recordColumns(), other.recordColumns());
    }

    public String toString() {
        return ToString.builder((String)"SourceSchema").add("RecordFormat", (Object)this.recordFormat()).add("RecordEncoding", (Object)this.recordEncoding()).add("RecordColumns", this.recordColumns()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RecordFormat": {
                return Optional.of(clazz.cast(this.recordFormat()));
            }
            case "RecordEncoding": {
                return Optional.of(clazz.cast(this.recordEncoding()));
            }
            case "RecordColumns": {
                return Optional.of(clazz.cast(this.recordColumns()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SourceSchemaMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private RecordFormat recordFormat;
        private String recordEncoding;
        private List<RecordColumn> recordColumns;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceSchema model) {
            this.recordFormat(model.recordFormat);
            this.recordEncoding(model.recordEncoding);
            this.recordColumns(model.recordColumns);
        }

        public final RecordFormat.Builder getRecordFormat() {
            return this.recordFormat != null ? this.recordFormat.toBuilder() : null;
        }

        @Override
        public final Builder recordFormat(RecordFormat recordFormat) {
            this.recordFormat = recordFormat;
            return this;
        }

        public final void setRecordFormat(RecordFormat.BuilderImpl recordFormat) {
            this.recordFormat = recordFormat != null ? recordFormat.build() : null;
        }

        public final String getRecordEncoding() {
            return this.recordEncoding;
        }

        @Override
        public final Builder recordEncoding(String recordEncoding) {
            this.recordEncoding = recordEncoding;
            return this;
        }

        public final void setRecordEncoding(String recordEncoding) {
            this.recordEncoding = recordEncoding;
        }

        public final Collection<RecordColumn.Builder> getRecordColumns() {
            return this.recordColumns != null ? (Collection)this.recordColumns.stream().map(RecordColumn::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder recordColumns(Collection<RecordColumn> recordColumns) {
            this.recordColumns = RecordColumnsCopier.copy(recordColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordColumns(RecordColumn ... recordColumns) {
            this.recordColumns(Arrays.asList(recordColumns));
            return this;
        }

        public final void setRecordColumns(Collection<RecordColumn.BuilderImpl> recordColumns) {
            this.recordColumns = RecordColumnsCopier.copyFromBuilder(recordColumns);
        }

        public SourceSchema build() {
            return new SourceSchema(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SourceSchema> {
        public Builder recordFormat(RecordFormat var1);

        default public Builder recordFormat(Consumer<RecordFormat.Builder> recordFormat) {
            return this.recordFormat((RecordFormat)((RecordFormat.Builder)RecordFormat.builder().apply(recordFormat)).build());
        }

        public Builder recordEncoding(String var1);

        public Builder recordColumns(Collection<RecordColumn> var1);

        public Builder recordColumns(RecordColumn ... var1);
    }
}

