/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.transform.S3ReferenceDataSourceMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class S3ReferenceDataSource
implements StructuredPojo,
ToCopyableBuilder<Builder, S3ReferenceDataSource> {
    private final String bucketARN;
    private final String fileKey;
    private final String referenceRoleARN;

    private S3ReferenceDataSource(BuilderImpl builder) {
        this.bucketARN = builder.bucketARN;
        this.fileKey = builder.fileKey;
        this.referenceRoleARN = builder.referenceRoleARN;
    }

    public String bucketARN() {
        return this.bucketARN;
    }

    public String fileKey() {
        return this.fileKey;
    }

    public String referenceRoleARN() {
        return this.referenceRoleARN;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.referenceRoleARN());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ReferenceDataSource)) {
            return false;
        }
        S3ReferenceDataSource other = (S3ReferenceDataSource)obj;
        return Objects.equals(this.bucketARN(), other.bucketARN()) && Objects.equals(this.fileKey(), other.fileKey()) && Objects.equals(this.referenceRoleARN(), other.referenceRoleARN());
    }

    public String toString() {
        return ToString.builder((String)"S3ReferenceDataSource").add("BucketARN", (Object)this.bucketARN()).add("FileKey", (Object)this.fileKey()).add("ReferenceRoleARN", (Object)this.referenceRoleARN()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BucketARN": {
                return Optional.of(clazz.cast(this.bucketARN()));
            }
            case "FileKey": {
                return Optional.of(clazz.cast(this.fileKey()));
            }
            case "ReferenceRoleARN": {
                return Optional.of(clazz.cast(this.referenceRoleARN()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3ReferenceDataSourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String bucketARN;
        private String fileKey;
        private String referenceRoleARN;

        private BuilderImpl() {
        }

        private BuilderImpl(S3ReferenceDataSource model) {
            this.bucketARN(model.bucketARN);
            this.fileKey(model.fileKey);
            this.referenceRoleARN(model.referenceRoleARN);
        }

        public final String getBucketARN() {
            return this.bucketARN;
        }

        @Override
        public final Builder bucketARN(String bucketARN) {
            this.bucketARN = bucketARN;
            return this;
        }

        public final void setBucketARN(String bucketARN) {
            this.bucketARN = bucketARN;
        }

        public final String getFileKey() {
            return this.fileKey;
        }

        @Override
        public final Builder fileKey(String fileKey) {
            this.fileKey = fileKey;
            return this;
        }

        public final void setFileKey(String fileKey) {
            this.fileKey = fileKey;
        }

        public final String getReferenceRoleARN() {
            return this.referenceRoleARN;
        }

        @Override
        public final Builder referenceRoleARN(String referenceRoleARN) {
            this.referenceRoleARN = referenceRoleARN;
            return this;
        }

        public final void setReferenceRoleARN(String referenceRoleARN) {
            this.referenceRoleARN = referenceRoleARN;
        }

        public S3ReferenceDataSource build() {
            return new S3ReferenceDataSource(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, S3ReferenceDataSource> {
        public Builder bucketARN(String var1);

        public Builder fileKey(String var1);

        public Builder referenceRoleARN(String var1);
    }
}

