/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.model.RecordColumn;
import software.amazon.awssdk.services.kinesisanalytics.model.RecordColumnsCopier;
import software.amazon.awssdk.services.kinesisanalytics.model.RecordFormat;
import software.amazon.awssdk.services.kinesisanalytics.transform.InputSchemaUpdateMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InputSchemaUpdate
implements StructuredPojo,
ToCopyableBuilder<Builder, InputSchemaUpdate> {
    private final RecordFormat recordFormatUpdate;
    private final String recordEncodingUpdate;
    private final List<RecordColumn> recordColumnUpdates;

    private InputSchemaUpdate(BuilderImpl builder) {
        this.recordFormatUpdate = builder.recordFormatUpdate;
        this.recordEncodingUpdate = builder.recordEncodingUpdate;
        this.recordColumnUpdates = builder.recordColumnUpdates;
    }

    public RecordFormat recordFormatUpdate() {
        return this.recordFormatUpdate;
    }

    public String recordEncodingUpdate() {
        return this.recordEncodingUpdate;
    }

    public List<RecordColumn> recordColumnUpdates() {
        return this.recordColumnUpdates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.recordFormatUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordEncodingUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordColumnUpdates());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputSchemaUpdate)) {
            return false;
        }
        InputSchemaUpdate other = (InputSchemaUpdate)obj;
        return Objects.equals(this.recordFormatUpdate(), other.recordFormatUpdate()) && Objects.equals(this.recordEncodingUpdate(), other.recordEncodingUpdate()) && Objects.equals(this.recordColumnUpdates(), other.recordColumnUpdates());
    }

    public String toString() {
        return ToString.builder((String)"InputSchemaUpdate").add("RecordFormatUpdate", (Object)this.recordFormatUpdate()).add("RecordEncodingUpdate", (Object)this.recordEncodingUpdate()).add("RecordColumnUpdates", this.recordColumnUpdates()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RecordFormatUpdate": {
                return Optional.of(clazz.cast(this.recordFormatUpdate()));
            }
            case "RecordEncodingUpdate": {
                return Optional.of(clazz.cast(this.recordEncodingUpdate()));
            }
            case "RecordColumnUpdates": {
                return Optional.of(clazz.cast(this.recordColumnUpdates()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InputSchemaUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private RecordFormat recordFormatUpdate;
        private String recordEncodingUpdate;
        private List<RecordColumn> recordColumnUpdates;

        private BuilderImpl() {
        }

        private BuilderImpl(InputSchemaUpdate model) {
            this.recordFormatUpdate(model.recordFormatUpdate);
            this.recordEncodingUpdate(model.recordEncodingUpdate);
            this.recordColumnUpdates(model.recordColumnUpdates);
        }

        public final RecordFormat.Builder getRecordFormatUpdate() {
            return this.recordFormatUpdate != null ? this.recordFormatUpdate.toBuilder() : null;
        }

        @Override
        public final Builder recordFormatUpdate(RecordFormat recordFormatUpdate) {
            this.recordFormatUpdate = recordFormatUpdate;
            return this;
        }

        public final void setRecordFormatUpdate(RecordFormat.BuilderImpl recordFormatUpdate) {
            this.recordFormatUpdate = recordFormatUpdate != null ? recordFormatUpdate.build() : null;
        }

        public final String getRecordEncodingUpdate() {
            return this.recordEncodingUpdate;
        }

        @Override
        public final Builder recordEncodingUpdate(String recordEncodingUpdate) {
            this.recordEncodingUpdate = recordEncodingUpdate;
            return this;
        }

        public final void setRecordEncodingUpdate(String recordEncodingUpdate) {
            this.recordEncodingUpdate = recordEncodingUpdate;
        }

        public final Collection<RecordColumn.Builder> getRecordColumnUpdates() {
            return this.recordColumnUpdates != null ? (Collection)this.recordColumnUpdates.stream().map(RecordColumn::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder recordColumnUpdates(Collection<RecordColumn> recordColumnUpdates) {
            this.recordColumnUpdates = RecordColumnsCopier.copy(recordColumnUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordColumnUpdates(RecordColumn ... recordColumnUpdates) {
            this.recordColumnUpdates(Arrays.asList(recordColumnUpdates));
            return this;
        }

        public final void setRecordColumnUpdates(Collection<RecordColumn.BuilderImpl> recordColumnUpdates) {
            this.recordColumnUpdates = RecordColumnsCopier.copyFromBuilder(recordColumnUpdates);
        }

        public InputSchemaUpdate build() {
            return new InputSchemaUpdate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InputSchemaUpdate> {
        public Builder recordFormatUpdate(RecordFormat var1);

        default public Builder recordFormatUpdate(Consumer<RecordFormat.Builder> recordFormatUpdate) {
            return this.recordFormatUpdate((RecordFormat)((RecordFormat.Builder)RecordFormat.builder().apply(recordFormatUpdate)).build());
        }

        public Builder recordEncodingUpdate(String var1);

        public Builder recordColumnUpdates(Collection<RecordColumn> var1);

        public Builder recordColumnUpdates(RecordColumn ... var1);
    }
}

