/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.kinesis.model.KinesisResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateShardCountResponse
extends KinesisResponse
implements ToCopyableBuilder<Builder, UpdateShardCountResponse> {
    private final String streamName;
    private final Integer currentShardCount;
    private final Integer targetShardCount;

    private UpdateShardCountResponse(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.currentShardCount = builder.currentShardCount;
        this.targetShardCount = builder.targetShardCount;
    }

    public String streamName() {
        return this.streamName;
    }

    public Integer currentShardCount() {
        return this.currentShardCount;
    }

    public Integer targetShardCount() {
        return this.targetShardCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentShardCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetShardCount());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateShardCountResponse)) {
            return false;
        }
        UpdateShardCountResponse other = (UpdateShardCountResponse)((Object)obj);
        return Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.currentShardCount(), other.currentShardCount()) && Objects.equals(this.targetShardCount(), other.targetShardCount());
    }

    public String toString() {
        return ToString.builder((String)"UpdateShardCountResponse").add("StreamName", (Object)this.streamName()).add("CurrentShardCount", (Object)this.currentShardCount()).add("TargetShardCount", (Object)this.targetShardCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamName": {
                return Optional.of(clazz.cast(this.streamName()));
            }
            case "CurrentShardCount": {
                return Optional.of(clazz.cast(this.currentShardCount()));
            }
            case "TargetShardCount": {
                return Optional.of(clazz.cast(this.targetShardCount()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends KinesisResponse.BuilderImpl
    implements Builder {
        private String streamName;
        private Integer currentShardCount;
        private Integer targetShardCount;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateShardCountResponse model) {
            this.streamName(model.streamName);
            this.currentShardCount(model.currentShardCount);
            this.targetShardCount(model.targetShardCount);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final Integer getCurrentShardCount() {
            return this.currentShardCount;
        }

        @Override
        public final Builder currentShardCount(Integer currentShardCount) {
            this.currentShardCount = currentShardCount;
            return this;
        }

        public final void setCurrentShardCount(Integer currentShardCount) {
            this.currentShardCount = currentShardCount;
        }

        public final Integer getTargetShardCount() {
            return this.targetShardCount;
        }

        @Override
        public final Builder targetShardCount(Integer targetShardCount) {
            this.targetShardCount = targetShardCount;
            return this;
        }

        public final void setTargetShardCount(Integer targetShardCount) {
            this.targetShardCount = targetShardCount;
        }

        @Override
        public UpdateShardCountResponse build() {
            return new UpdateShardCountResponse(this);
        }
    }

    public static interface Builder
    extends KinesisResponse.Builder,
    CopyableBuilder<Builder, UpdateShardCountResponse> {
        public Builder streamName(String var1);

        public Builder currentShardCount(Integer var1);

        public Builder targetShardCount(Integer var1);
    }
}

