/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.kinesis.model.KinesisRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListStreamsRequest
extends KinesisRequest
implements ToCopyableBuilder<Builder, ListStreamsRequest> {
    private final Integer limit;
    private final String exclusiveStartStreamName;

    private ListStreamsRequest(BuilderImpl builder) {
        super(builder);
        this.limit = builder.limit;
        this.exclusiveStartStreamName = builder.exclusiveStartStreamName;
    }

    public Integer limit() {
        return this.limit;
    }

    public String exclusiveStartStreamName() {
        return this.exclusiveStartStreamName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.exclusiveStartStreamName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStreamsRequest)) {
            return false;
        }
        ListStreamsRequest other = (ListStreamsRequest)((Object)obj);
        return Objects.equals(this.limit(), other.limit()) && Objects.equals(this.exclusiveStartStreamName(), other.exclusiveStartStreamName());
    }

    public String toString() {
        return ToString.builder((String)"ListStreamsRequest").add("Limit", (Object)this.limit()).add("ExclusiveStartStreamName", (Object)this.exclusiveStartStreamName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Limit": {
                return Optional.of(clazz.cast(this.limit()));
            }
            case "ExclusiveStartStreamName": {
                return Optional.of(clazz.cast(this.exclusiveStartStreamName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends KinesisRequest.BuilderImpl
    implements Builder {
        private Integer limit;
        private String exclusiveStartStreamName;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStreamsRequest model) {
            this.limit(model.limit);
            this.exclusiveStartStreamName(model.exclusiveStartStreamName);
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getExclusiveStartStreamName() {
            return this.exclusiveStartStreamName;
        }

        @Override
        public final Builder exclusiveStartStreamName(String exclusiveStartStreamName) {
            this.exclusiveStartStreamName = exclusiveStartStreamName;
            return this;
        }

        public final void setExclusiveStartStreamName(String exclusiveStartStreamName) {
            this.exclusiveStartStreamName = exclusiveStartStreamName;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListStreamsRequest build() {
            return new ListStreamsRequest(this);
        }
    }

    public static interface Builder
    extends KinesisRequest.Builder,
    CopyableBuilder<Builder, ListStreamsRequest> {
        public Builder limit(Integer var1);

        public Builder exclusiveStartStreamName(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

