/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.kinesis.model.KinesisRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DecreaseStreamRetentionPeriodRequest
extends KinesisRequest
implements ToCopyableBuilder<Builder, DecreaseStreamRetentionPeriodRequest> {
    private final String streamName;
    private final Integer retentionPeriodHours;

    private DecreaseStreamRetentionPeriodRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.retentionPeriodHours = builder.retentionPeriodHours;
    }

    public String streamName() {
        return this.streamName;
    }

    public Integer retentionPeriodHours() {
        return this.retentionPeriodHours;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionPeriodHours());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DecreaseStreamRetentionPeriodRequest)) {
            return false;
        }
        DecreaseStreamRetentionPeriodRequest other = (DecreaseStreamRetentionPeriodRequest)((Object)obj);
        return Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.retentionPeriodHours(), other.retentionPeriodHours());
    }

    public String toString() {
        return ToString.builder((String)"DecreaseStreamRetentionPeriodRequest").add("StreamName", (Object)this.streamName()).add("RetentionPeriodHours", (Object)this.retentionPeriodHours()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamName": {
                return Optional.of(clazz.cast(this.streamName()));
            }
            case "RetentionPeriodHours": {
                return Optional.of(clazz.cast(this.retentionPeriodHours()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends KinesisRequest.BuilderImpl
    implements Builder {
        private String streamName;
        private Integer retentionPeriodHours;

        private BuilderImpl() {
        }

        private BuilderImpl(DecreaseStreamRetentionPeriodRequest model) {
            this.streamName(model.streamName);
            this.retentionPeriodHours(model.retentionPeriodHours);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final Integer getRetentionPeriodHours() {
            return this.retentionPeriodHours;
        }

        @Override
        public final Builder retentionPeriodHours(Integer retentionPeriodHours) {
            this.retentionPeriodHours = retentionPeriodHours;
            return this;
        }

        public final void setRetentionPeriodHours(Integer retentionPeriodHours) {
            this.retentionPeriodHours = retentionPeriodHours;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DecreaseStreamRetentionPeriodRequest build() {
            return new DecreaseStreamRetentionPeriodRequest(this);
        }
    }

    public static interface Builder
    extends KinesisRequest.Builder,
    CopyableBuilder<Builder, DecreaseStreamRetentionPeriodRequest> {
        public Builder streamName(String var1);

        public Builder retentionPeriodHours(Integer var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

