/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.model.SourceDescription;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SourceDescriptionMarshaller {
    private static final MarshallingInfo<StructuredPojo> KINESISSTREAMSOURCEDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KinesisStreamSourceDescription").isBinary(false).build();
    private static final SourceDescriptionMarshaller INSTANCE = new SourceDescriptionMarshaller();

    private SourceDescriptionMarshaller() {
    }

    public static SourceDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SourceDescription sourceDescription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)sourceDescription, (String)"sourceDescription");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)sourceDescription.kinesisStreamSourceDescription(), KINESISSTREAMSOURCEDESCRIPTION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

