/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.model.KMSEncryptionConfig;
import software.amazon.awssdk.services.firehose.model.NoEncryptionConfig;
import software.amazon.awssdk.services.firehose.transform.EncryptionConfigurationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EncryptionConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, EncryptionConfiguration> {
    private final String noEncryptionConfig;
    private final KMSEncryptionConfig kmsEncryptionConfig;

    private EncryptionConfiguration(BuilderImpl builder) {
        this.noEncryptionConfig = builder.noEncryptionConfig;
        this.kmsEncryptionConfig = builder.kmsEncryptionConfig;
    }

    public NoEncryptionConfig noEncryptionConfig() {
        return NoEncryptionConfig.fromValue(this.noEncryptionConfig);
    }

    public String noEncryptionConfigString() {
        return this.noEncryptionConfig;
    }

    public KMSEncryptionConfig kmsEncryptionConfig() {
        return this.kmsEncryptionConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.noEncryptionConfigString());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsEncryptionConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptionConfiguration)) {
            return false;
        }
        EncryptionConfiguration other = (EncryptionConfiguration)obj;
        return Objects.equals(this.noEncryptionConfigString(), other.noEncryptionConfigString()) && Objects.equals(this.kmsEncryptionConfig(), other.kmsEncryptionConfig());
    }

    public String toString() {
        return ToString.builder((String)"EncryptionConfiguration").add("NoEncryptionConfig", (Object)this.noEncryptionConfigString()).add("KMSEncryptionConfig", (Object)this.kmsEncryptionConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NoEncryptionConfig": {
                return Optional.of(clazz.cast(this.noEncryptionConfigString()));
            }
            case "KMSEncryptionConfig": {
                return Optional.of(clazz.cast(this.kmsEncryptionConfig()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EncryptionConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String noEncryptionConfig;
        private KMSEncryptionConfig kmsEncryptionConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(EncryptionConfiguration model) {
            this.noEncryptionConfig(model.noEncryptionConfig);
            this.kmsEncryptionConfig(model.kmsEncryptionConfig);
        }

        public final String getNoEncryptionConfig() {
            return this.noEncryptionConfig;
        }

        @Override
        public final Builder noEncryptionConfig(String noEncryptionConfig) {
            this.noEncryptionConfig = noEncryptionConfig;
            return this;
        }

        @Override
        public final Builder noEncryptionConfig(NoEncryptionConfig noEncryptionConfig) {
            this.noEncryptionConfig(noEncryptionConfig.toString());
            return this;
        }

        public final void setNoEncryptionConfig(String noEncryptionConfig) {
            this.noEncryptionConfig = noEncryptionConfig;
        }

        public final KMSEncryptionConfig.Builder getKMSEncryptionConfig() {
            return this.kmsEncryptionConfig != null ? this.kmsEncryptionConfig.toBuilder() : null;
        }

        @Override
        public final Builder kmsEncryptionConfig(KMSEncryptionConfig kmsEncryptionConfig) {
            this.kmsEncryptionConfig = kmsEncryptionConfig;
            return this;
        }

        public final void setKMSEncryptionConfig(KMSEncryptionConfig.BuilderImpl kmsEncryptionConfig) {
            this.kmsEncryptionConfig = kmsEncryptionConfig != null ? kmsEncryptionConfig.build() : null;
        }

        public EncryptionConfiguration build() {
            return new EncryptionConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EncryptionConfiguration> {
        public Builder noEncryptionConfig(String var1);

        public Builder noEncryptionConfig(NoEncryptionConfig var1);

        public Builder kmsEncryptionConfig(KMSEncryptionConfig var1);

        default public Builder kmsEncryptionConfig(Consumer<KMSEncryptionConfig.Builder> kmsEncryptionConfig) {
            return this.kmsEncryptionConfig((KMSEncryptionConfig)((KMSEncryptionConfig.Builder)KMSEncryptionConfig.builder().apply(kmsEncryptionConfig)).build());
        }
    }
}

