/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.kinesisanalytics.model.ApplicationSummariesCopier;
import software.amazon.awssdk.services.kinesisanalytics.model.ApplicationSummary;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListApplicationsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListApplicationsResponse> {
    private final List<ApplicationSummary> applicationSummaries;
    private final Boolean hasMoreApplications;

    private ListApplicationsResponse(BuilderImpl builder) {
        this.applicationSummaries = builder.applicationSummaries;
        this.hasMoreApplications = builder.hasMoreApplications;
    }

    public List<ApplicationSummary> applicationSummaries() {
        return this.applicationSummaries;
    }

    public Boolean hasMoreApplications() {
        return this.hasMoreApplications;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.applicationSummaries() == null ? 0 : this.applicationSummaries().hashCode());
        hashCode = 31 * hashCode + (this.hasMoreApplications() == null ? 0 : this.hasMoreApplications().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationsResponse)) {
            return false;
        }
        ListApplicationsResponse other = (ListApplicationsResponse)((Object)obj);
        if (other.applicationSummaries() == null ^ this.applicationSummaries() == null) {
            return false;
        }
        if (other.applicationSummaries() != null && !other.applicationSummaries().equals(this.applicationSummaries())) {
            return false;
        }
        if (other.hasMoreApplications() == null ^ this.hasMoreApplications() == null) {
            return false;
        }
        return other.hasMoreApplications() == null || other.hasMoreApplications().equals(this.hasMoreApplications());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.applicationSummaries() != null) {
            sb.append("ApplicationSummaries: ").append(this.applicationSummaries()).append(",");
        }
        if (this.hasMoreApplications() != null) {
            sb.append("HasMoreApplications: ").append(this.hasMoreApplications()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<ApplicationSummary> applicationSummaries;
        private Boolean hasMoreApplications;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApplicationsResponse model) {
            this.setApplicationSummaries(model.applicationSummaries);
            this.setHasMoreApplications(model.hasMoreApplications);
        }

        public final Collection<ApplicationSummary> getApplicationSummaries() {
            return this.applicationSummaries;
        }

        @Override
        public final Builder applicationSummaries(Collection<ApplicationSummary> applicationSummaries) {
            this.applicationSummaries = ApplicationSummariesCopier.copy(applicationSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationSummaries(ApplicationSummary ... applicationSummaries) {
            this.applicationSummaries(Arrays.asList(applicationSummaries));
            return this;
        }

        public final void setApplicationSummaries(Collection<ApplicationSummary> applicationSummaries) {
            this.applicationSummaries = ApplicationSummariesCopier.copy(applicationSummaries);
        }

        public final Boolean getHasMoreApplications() {
            return this.hasMoreApplications;
        }

        @Override
        public final Builder hasMoreApplications(Boolean hasMoreApplications) {
            this.hasMoreApplications = hasMoreApplications;
            return this;
        }

        public final void setHasMoreApplications(Boolean hasMoreApplications) {
            this.hasMoreApplications = hasMoreApplications;
        }

        public ListApplicationsResponse build() {
            return new ListApplicationsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListApplicationsResponse> {
        public Builder applicationSummaries(Collection<ApplicationSummary> var1);

        public Builder applicationSummaries(ApplicationSummary ... var1);

        public Builder hasMoreApplications(Boolean var1);
    }
}

