/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.kinesisanalytics.model.ReferenceDataSource;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AddApplicationReferenceDataSourceRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, AddApplicationReferenceDataSourceRequest> {
    private final String applicationName;
    private final Long currentApplicationVersionId;
    private final ReferenceDataSource referenceDataSource;

    private AddApplicationReferenceDataSourceRequest(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.currentApplicationVersionId = builder.currentApplicationVersionId;
        this.referenceDataSource = builder.referenceDataSource;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public Long currentApplicationVersionId() {
        return this.currentApplicationVersionId;
    }

    public ReferenceDataSource referenceDataSource() {
        return this.referenceDataSource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.applicationName() == null ? 0 : this.applicationName().hashCode());
        hashCode = 31 * hashCode + (this.currentApplicationVersionId() == null ? 0 : this.currentApplicationVersionId().hashCode());
        hashCode = 31 * hashCode + (this.referenceDataSource() == null ? 0 : this.referenceDataSource().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddApplicationReferenceDataSourceRequest)) {
            return false;
        }
        AddApplicationReferenceDataSourceRequest other = (AddApplicationReferenceDataSourceRequest)((Object)obj);
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.currentApplicationVersionId() == null ^ this.currentApplicationVersionId() == null) {
            return false;
        }
        if (other.currentApplicationVersionId() != null && !other.currentApplicationVersionId().equals(this.currentApplicationVersionId())) {
            return false;
        }
        if (other.referenceDataSource() == null ^ this.referenceDataSource() == null) {
            return false;
        }
        return other.referenceDataSource() == null || other.referenceDataSource().equals(this.referenceDataSource());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.applicationName() != null) {
            sb.append("ApplicationName: ").append(this.applicationName()).append(",");
        }
        if (this.currentApplicationVersionId() != null) {
            sb.append("CurrentApplicationVersionId: ").append(this.currentApplicationVersionId()).append(",");
        }
        if (this.referenceDataSource() != null) {
            sb.append("ReferenceDataSource: ").append(this.referenceDataSource()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String applicationName;
        private Long currentApplicationVersionId;
        private ReferenceDataSource referenceDataSource;

        private BuilderImpl() {
        }

        private BuilderImpl(AddApplicationReferenceDataSourceRequest model) {
            this.setApplicationName(model.applicationName);
            this.setCurrentApplicationVersionId(model.currentApplicationVersionId);
            this.setReferenceDataSource(model.referenceDataSource);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final Long getCurrentApplicationVersionId() {
            return this.currentApplicationVersionId;
        }

        @Override
        public final Builder currentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
            return this;
        }

        public final void setCurrentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
        }

        public final ReferenceDataSource getReferenceDataSource() {
            return this.referenceDataSource;
        }

        @Override
        public final Builder referenceDataSource(ReferenceDataSource referenceDataSource) {
            this.referenceDataSource = referenceDataSource;
            return this;
        }

        public final void setReferenceDataSource(ReferenceDataSource referenceDataSource) {
            this.referenceDataSource = referenceDataSource;
        }

        public AddApplicationReferenceDataSourceRequest build() {
            return new AddApplicationReferenceDataSourceRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AddApplicationReferenceDataSourceRequest> {
        public Builder applicationName(String var1);

        public Builder currentApplicationVersionId(Long var1);

        public Builder referenceDataSource(ReferenceDataSource var1);
    }
}

