/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.kinesis.model.MetricsName;
import software.amazon.awssdk.services.kinesis.model.MetricsNameListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EnableEnhancedMonitoringRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, EnableEnhancedMonitoringRequest> {
    private final String streamName;
    private final List<String> shardLevelMetrics;

    private EnableEnhancedMonitoringRequest(BuilderImpl builder) {
        this.streamName = builder.streamName;
        this.shardLevelMetrics = builder.shardLevelMetrics;
    }

    public String streamName() {
        return this.streamName;
    }

    public List<String> shardLevelMetrics() {
        return this.shardLevelMetrics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.streamName() == null ? 0 : this.streamName().hashCode());
        hashCode = 31 * hashCode + (this.shardLevelMetrics() == null ? 0 : this.shardLevelMetrics().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableEnhancedMonitoringRequest)) {
            return false;
        }
        EnableEnhancedMonitoringRequest other = (EnableEnhancedMonitoringRequest)((Object)obj);
        if (other.streamName() == null ^ this.streamName() == null) {
            return false;
        }
        if (other.streamName() != null && !other.streamName().equals(this.streamName())) {
            return false;
        }
        if (other.shardLevelMetrics() == null ^ this.shardLevelMetrics() == null) {
            return false;
        }
        return other.shardLevelMetrics() == null || other.shardLevelMetrics().equals(this.shardLevelMetrics());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.streamName() != null) {
            sb.append("StreamName: ").append(this.streamName()).append(",");
        }
        if (this.shardLevelMetrics() != null) {
            sb.append("ShardLevelMetrics: ").append(this.shardLevelMetrics()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String streamName;
        private List<String> shardLevelMetrics;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableEnhancedMonitoringRequest model) {
            this.setStreamName(model.streamName);
            this.setShardLevelMetrics(model.shardLevelMetrics);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final Collection<String> getShardLevelMetrics() {
            return this.shardLevelMetrics;
        }

        @Override
        public final Builder shardLevelMetrics(Collection<String> shardLevelMetrics) {
            this.shardLevelMetrics = MetricsNameListCopier.copy(shardLevelMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shardLevelMetrics(String ... shardLevelMetrics) {
            this.shardLevelMetrics(Arrays.asList(shardLevelMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shardLevelMetrics(MetricsName ... shardLevelMetrics) {
            this.shardLevelMetrics(Arrays.asList(shardLevelMetrics).stream().map(Object::toString).collect(Collectors.toList()));
            return this;
        }

        public final void setShardLevelMetrics(Collection<String> shardLevelMetrics) {
            this.shardLevelMetrics = MetricsNameListCopier.copy(shardLevelMetrics);
        }

        public EnableEnhancedMonitoringRequest build() {
            return new EnableEnhancedMonitoringRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EnableEnhancedMonitoringRequest> {
        public Builder streamName(String var1);

        public Builder shardLevelMetrics(Collection<String> var1);

        public Builder shardLevelMetrics(String ... var1);

        public Builder shardLevelMetrics(MetricsName ... var1);
    }
}

