/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.transform;

import java.nio.ByteBuffer;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesis.model.PutRecordRequest;

@SdkInternalApi
public class PutRecordRequestModelMarshaller {
    private static final MarshallingInfo<String> STREAMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamName").build();
    private static final MarshallingInfo<ByteBuffer> DATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Data").build();
    private static final MarshallingInfo<String> PARTITIONKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PartitionKey").build();
    private static final MarshallingInfo<String> EXPLICITHASHKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExplicitHashKey").build();
    private static final MarshallingInfo<String> SEQUENCENUMBERFORORDERING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SequenceNumberForOrdering").build();
    private static final PutRecordRequestModelMarshaller INSTANCE = new PutRecordRequestModelMarshaller();

    public static PutRecordRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PutRecordRequest putRecordRequest, ProtocolMarshaller protocolMarshaller) {
        if (putRecordRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)putRecordRequest.streamName(), STREAMNAME_BINDING);
            protocolMarshaller.marshall((Object)putRecordRequest.data(), DATA_BINDING);
            protocolMarshaller.marshall((Object)putRecordRequest.partitionKey(), PARTITIONKEY_BINDING);
            protocolMarshaller.marshall((Object)putRecordRequest.explicitHashKey(), EXPLICITHASHKEY_BINDING);
            protocolMarshaller.marshall((Object)putRecordRequest.sequenceNumberForOrdering(), SEQUENCENUMBERFORORDERING_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

