/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesis.model.MergeShardsRequest;

@SdkInternalApi
public class MergeShardsRequestModelMarshaller {
    private static final MarshallingInfo<String> STREAMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamName").build();
    private static final MarshallingInfo<String> SHARDTOMERGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ShardToMerge").build();
    private static final MarshallingInfo<String> ADJACENTSHARDTOMERGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AdjacentShardToMerge").build();
    private static final MergeShardsRequestModelMarshaller INSTANCE = new MergeShardsRequestModelMarshaller();

    public static MergeShardsRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(MergeShardsRequest mergeShardsRequest, ProtocolMarshaller protocolMarshaller) {
        if (mergeShardsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)mergeShardsRequest.streamName(), STREAMNAME_BINDING);
            protocolMarshaller.marshall((Object)mergeShardsRequest.shardToMerge(), SHARDTOMERGE_BINDING);
            protocolMarshaller.marshall((Object)mergeShardsRequest.adjacentShardToMerge(), ADJACENTSHARDTOMERGE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

