/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.nio.ByteBuffer;
import java.time.Instant;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.kinesis.transform.RecordMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Record
implements StructuredPojo,
ToCopyableBuilder<Builder, Record> {
    private final String sequenceNumber;
    private final Instant approximateArrivalTimestamp;
    private final ByteBuffer data;
    private final String partitionKey;

    private Record(BuilderImpl builder) {
        this.sequenceNumber = builder.sequenceNumber;
        this.approximateArrivalTimestamp = builder.approximateArrivalTimestamp;
        this.data = builder.data;
        this.partitionKey = builder.partitionKey;
    }

    public String sequenceNumber() {
        return this.sequenceNumber;
    }

    public Instant approximateArrivalTimestamp() {
        return this.approximateArrivalTimestamp;
    }

    public ByteBuffer data() {
        return this.data == null ? null : this.data.asReadOnlyBuffer();
    }

    public String partitionKey() {
        return this.partitionKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.sequenceNumber() == null ? 0 : this.sequenceNumber().hashCode());
        hashCode = 31 * hashCode + (this.approximateArrivalTimestamp() == null ? 0 : this.approximateArrivalTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.data() == null ? 0 : this.data().hashCode());
        hashCode = 31 * hashCode + (this.partitionKey() == null ? 0 : this.partitionKey().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Record)) {
            return false;
        }
        Record other = (Record)obj;
        if (other.sequenceNumber() == null ^ this.sequenceNumber() == null) {
            return false;
        }
        if (other.sequenceNumber() != null && !other.sequenceNumber().equals(this.sequenceNumber())) {
            return false;
        }
        if (other.approximateArrivalTimestamp() == null ^ this.approximateArrivalTimestamp() == null) {
            return false;
        }
        if (other.approximateArrivalTimestamp() != null && !other.approximateArrivalTimestamp().equals(this.approximateArrivalTimestamp())) {
            return false;
        }
        if (other.data() == null ^ this.data() == null) {
            return false;
        }
        if (other.data() != null && !other.data().equals(this.data())) {
            return false;
        }
        if (other.partitionKey() == null ^ this.partitionKey() == null) {
            return false;
        }
        return other.partitionKey() == null || other.partitionKey().equals(this.partitionKey());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.sequenceNumber() != null) {
            sb.append("SequenceNumber: ").append(this.sequenceNumber()).append(",");
        }
        if (this.approximateArrivalTimestamp() != null) {
            sb.append("ApproximateArrivalTimestamp: ").append(this.approximateArrivalTimestamp()).append(",");
        }
        if (this.data() != null) {
            sb.append("Data: ").append(this.data()).append(",");
        }
        if (this.partitionKey() != null) {
            sb.append("PartitionKey: ").append(this.partitionKey()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RecordMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String sequenceNumber;
        private Instant approximateArrivalTimestamp;
        private ByteBuffer data;
        private String partitionKey;

        private BuilderImpl() {
        }

        private BuilderImpl(Record model) {
            this.setSequenceNumber(model.sequenceNumber);
            this.setApproximateArrivalTimestamp(model.approximateArrivalTimestamp);
            this.setData(model.data);
            this.setPartitionKey(model.partitionKey);
        }

        public final String getSequenceNumber() {
            return this.sequenceNumber;
        }

        @Override
        public final Builder sequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        public final void setSequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
        }

        public final Instant getApproximateArrivalTimestamp() {
            return this.approximateArrivalTimestamp;
        }

        @Override
        public final Builder approximateArrivalTimestamp(Instant approximateArrivalTimestamp) {
            this.approximateArrivalTimestamp = approximateArrivalTimestamp;
            return this;
        }

        public final void setApproximateArrivalTimestamp(Instant approximateArrivalTimestamp) {
            this.approximateArrivalTimestamp = approximateArrivalTimestamp;
        }

        public final ByteBuffer getData() {
            return this.data;
        }

        @Override
        public final Builder data(ByteBuffer data) {
            this.data = StandardMemberCopier.copy((ByteBuffer)data);
            return this;
        }

        public final void setData(ByteBuffer data) {
            this.data = StandardMemberCopier.copy((ByteBuffer)data);
        }

        public final String getPartitionKey() {
            return this.partitionKey;
        }

        @Override
        public final Builder partitionKey(String partitionKey) {
            this.partitionKey = partitionKey;
            return this;
        }

        public final void setPartitionKey(String partitionKey) {
            this.partitionKey = partitionKey;
        }

        public Record build() {
            return new Record(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Record> {
        public Builder sequenceNumber(String var1);

        public Builder approximateArrivalTimestamp(Instant var1);

        public Builder data(ByteBuffer var1);

        public Builder partitionKey(String var1);
    }
}

