/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.transform.BufferingHintsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BufferingHints
implements StructuredPojo,
ToCopyableBuilder<Builder, BufferingHints> {
    private final Integer sizeInMBs;
    private final Integer intervalInSeconds;

    private BufferingHints(BuilderImpl builder) {
        this.sizeInMBs = builder.sizeInMBs;
        this.intervalInSeconds = builder.intervalInSeconds;
    }

    public Integer sizeInMBs() {
        return this.sizeInMBs;
    }

    public Integer intervalInSeconds() {
        return this.intervalInSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.sizeInMBs() == null ? 0 : this.sizeInMBs().hashCode());
        hashCode = 31 * hashCode + (this.intervalInSeconds() == null ? 0 : this.intervalInSeconds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BufferingHints)) {
            return false;
        }
        BufferingHints other = (BufferingHints)obj;
        if (other.sizeInMBs() == null ^ this.sizeInMBs() == null) {
            return false;
        }
        if (other.sizeInMBs() != null && !other.sizeInMBs().equals(this.sizeInMBs())) {
            return false;
        }
        if (other.intervalInSeconds() == null ^ this.intervalInSeconds() == null) {
            return false;
        }
        return other.intervalInSeconds() == null || other.intervalInSeconds().equals(this.intervalInSeconds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.sizeInMBs() != null) {
            sb.append("SizeInMBs: ").append(this.sizeInMBs()).append(",");
        }
        if (this.intervalInSeconds() != null) {
            sb.append("IntervalInSeconds: ").append(this.intervalInSeconds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BufferingHintsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Integer sizeInMBs;
        private Integer intervalInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(BufferingHints model) {
            this.setSizeInMBs(model.sizeInMBs);
            this.setIntervalInSeconds(model.intervalInSeconds);
        }

        public final Integer getSizeInMBs() {
            return this.sizeInMBs;
        }

        @Override
        public final Builder sizeInMBs(Integer sizeInMBs) {
            this.sizeInMBs = sizeInMBs;
            return this;
        }

        public final void setSizeInMBs(Integer sizeInMBs) {
            this.sizeInMBs = sizeInMBs;
        }

        public final Integer getIntervalInSeconds() {
            return this.intervalInSeconds;
        }

        @Override
        public final Builder intervalInSeconds(Integer intervalInSeconds) {
            this.intervalInSeconds = intervalInSeconds;
            return this;
        }

        public final void setIntervalInSeconds(Integer intervalInSeconds) {
            this.intervalInSeconds = intervalInSeconds;
        }

        public BufferingHints build() {
            return new BufferingHints(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BufferingHints> {
        public Builder sizeInMBs(Integer var1);

        public Builder intervalInSeconds(Integer var1);
    }
}

