/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.model.InAppStreamNamesCopier;
import software.amazon.awssdk.services.kinesisanalytics.model.InputParallelism;
import software.amazon.awssdk.services.kinesisanalytics.model.InputStartingPositionConfiguration;
import software.amazon.awssdk.services.kinesisanalytics.model.KinesisFirehoseInputDescription;
import software.amazon.awssdk.services.kinesisanalytics.model.KinesisStreamsInputDescription;
import software.amazon.awssdk.services.kinesisanalytics.model.SourceSchema;
import software.amazon.awssdk.services.kinesisanalytics.transform.InputDescriptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InputDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, InputDescription> {
    private final String inputId;
    private final String namePrefix;
    private final List<String> inAppStreamNames;
    private final KinesisStreamsInputDescription kinesisStreamsInputDescription;
    private final KinesisFirehoseInputDescription kinesisFirehoseInputDescription;
    private final SourceSchema inputSchema;
    private final InputParallelism inputParallelism;
    private final InputStartingPositionConfiguration inputStartingPositionConfiguration;

    private InputDescription(BuilderImpl builder) {
        this.inputId = builder.inputId;
        this.namePrefix = builder.namePrefix;
        this.inAppStreamNames = builder.inAppStreamNames;
        this.kinesisStreamsInputDescription = builder.kinesisStreamsInputDescription;
        this.kinesisFirehoseInputDescription = builder.kinesisFirehoseInputDescription;
        this.inputSchema = builder.inputSchema;
        this.inputParallelism = builder.inputParallelism;
        this.inputStartingPositionConfiguration = builder.inputStartingPositionConfiguration;
    }

    public String inputId() {
        return this.inputId;
    }

    public String namePrefix() {
        return this.namePrefix;
    }

    public List<String> inAppStreamNames() {
        return this.inAppStreamNames;
    }

    public KinesisStreamsInputDescription kinesisStreamsInputDescription() {
        return this.kinesisStreamsInputDescription;
    }

    public KinesisFirehoseInputDescription kinesisFirehoseInputDescription() {
        return this.kinesisFirehoseInputDescription;
    }

    public SourceSchema inputSchema() {
        return this.inputSchema;
    }

    public InputParallelism inputParallelism() {
        return this.inputParallelism;
    }

    public InputStartingPositionConfiguration inputStartingPositionConfiguration() {
        return this.inputStartingPositionConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.inputId() == null ? 0 : this.inputId().hashCode());
        hashCode = 31 * hashCode + (this.namePrefix() == null ? 0 : this.namePrefix().hashCode());
        hashCode = 31 * hashCode + (this.inAppStreamNames() == null ? 0 : this.inAppStreamNames().hashCode());
        hashCode = 31 * hashCode + (this.kinesisStreamsInputDescription() == null ? 0 : this.kinesisStreamsInputDescription().hashCode());
        hashCode = 31 * hashCode + (this.kinesisFirehoseInputDescription() == null ? 0 : this.kinesisFirehoseInputDescription().hashCode());
        hashCode = 31 * hashCode + (this.inputSchema() == null ? 0 : this.inputSchema().hashCode());
        hashCode = 31 * hashCode + (this.inputParallelism() == null ? 0 : this.inputParallelism().hashCode());
        hashCode = 31 * hashCode + (this.inputStartingPositionConfiguration() == null ? 0 : this.inputStartingPositionConfiguration().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputDescription)) {
            return false;
        }
        InputDescription other = (InputDescription)obj;
        if (other.inputId() == null ^ this.inputId() == null) {
            return false;
        }
        if (other.inputId() != null && !other.inputId().equals(this.inputId())) {
            return false;
        }
        if (other.namePrefix() == null ^ this.namePrefix() == null) {
            return false;
        }
        if (other.namePrefix() != null && !other.namePrefix().equals(this.namePrefix())) {
            return false;
        }
        if (other.inAppStreamNames() == null ^ this.inAppStreamNames() == null) {
            return false;
        }
        if (other.inAppStreamNames() != null && !other.inAppStreamNames().equals(this.inAppStreamNames())) {
            return false;
        }
        if (other.kinesisStreamsInputDescription() == null ^ this.kinesisStreamsInputDescription() == null) {
            return false;
        }
        if (other.kinesisStreamsInputDescription() != null && !other.kinesisStreamsInputDescription().equals(this.kinesisStreamsInputDescription())) {
            return false;
        }
        if (other.kinesisFirehoseInputDescription() == null ^ this.kinesisFirehoseInputDescription() == null) {
            return false;
        }
        if (other.kinesisFirehoseInputDescription() != null && !other.kinesisFirehoseInputDescription().equals(this.kinesisFirehoseInputDescription())) {
            return false;
        }
        if (other.inputSchema() == null ^ this.inputSchema() == null) {
            return false;
        }
        if (other.inputSchema() != null && !other.inputSchema().equals(this.inputSchema())) {
            return false;
        }
        if (other.inputParallelism() == null ^ this.inputParallelism() == null) {
            return false;
        }
        if (other.inputParallelism() != null && !other.inputParallelism().equals(this.inputParallelism())) {
            return false;
        }
        if (other.inputStartingPositionConfiguration() == null ^ this.inputStartingPositionConfiguration() == null) {
            return false;
        }
        return other.inputStartingPositionConfiguration() == null || other.inputStartingPositionConfiguration().equals(this.inputStartingPositionConfiguration());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.inputId() != null) {
            sb.append("InputId: ").append(this.inputId()).append(",");
        }
        if (this.namePrefix() != null) {
            sb.append("NamePrefix: ").append(this.namePrefix()).append(",");
        }
        if (this.inAppStreamNames() != null) {
            sb.append("InAppStreamNames: ").append(this.inAppStreamNames()).append(",");
        }
        if (this.kinesisStreamsInputDescription() != null) {
            sb.append("KinesisStreamsInputDescription: ").append(this.kinesisStreamsInputDescription()).append(",");
        }
        if (this.kinesisFirehoseInputDescription() != null) {
            sb.append("KinesisFirehoseInputDescription: ").append(this.kinesisFirehoseInputDescription()).append(",");
        }
        if (this.inputSchema() != null) {
            sb.append("InputSchema: ").append(this.inputSchema()).append(",");
        }
        if (this.inputParallelism() != null) {
            sb.append("InputParallelism: ").append(this.inputParallelism()).append(",");
        }
        if (this.inputStartingPositionConfiguration() != null) {
            sb.append("InputStartingPositionConfiguration: ").append(this.inputStartingPositionConfiguration()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InputDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String inputId;
        private String namePrefix;
        private List<String> inAppStreamNames;
        private KinesisStreamsInputDescription kinesisStreamsInputDescription;
        private KinesisFirehoseInputDescription kinesisFirehoseInputDescription;
        private SourceSchema inputSchema;
        private InputParallelism inputParallelism;
        private InputStartingPositionConfiguration inputStartingPositionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(InputDescription model) {
            this.setInputId(model.inputId);
            this.setNamePrefix(model.namePrefix);
            this.setInAppStreamNames(model.inAppStreamNames);
            this.setKinesisStreamsInputDescription(model.kinesisStreamsInputDescription);
            this.setKinesisFirehoseInputDescription(model.kinesisFirehoseInputDescription);
            this.setInputSchema(model.inputSchema);
            this.setInputParallelism(model.inputParallelism);
            this.setInputStartingPositionConfiguration(model.inputStartingPositionConfiguration);
        }

        public final String getInputId() {
            return this.inputId;
        }

        @Override
        public final Builder inputId(String inputId) {
            this.inputId = inputId;
            return this;
        }

        public final void setInputId(String inputId) {
            this.inputId = inputId;
        }

        public final String getNamePrefix() {
            return this.namePrefix;
        }

        @Override
        public final Builder namePrefix(String namePrefix) {
            this.namePrefix = namePrefix;
            return this;
        }

        public final void setNamePrefix(String namePrefix) {
            this.namePrefix = namePrefix;
        }

        public final Collection<String> getInAppStreamNames() {
            return this.inAppStreamNames;
        }

        @Override
        public final Builder inAppStreamNames(Collection<String> inAppStreamNames) {
            this.inAppStreamNames = InAppStreamNamesCopier.copy(inAppStreamNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inAppStreamNames(String ... inAppStreamNames) {
            this.inAppStreamNames(Arrays.asList(inAppStreamNames));
            return this;
        }

        public final void setInAppStreamNames(Collection<String> inAppStreamNames) {
            this.inAppStreamNames = InAppStreamNamesCopier.copy(inAppStreamNames);
        }

        @SafeVarargs
        public final void setInAppStreamNames(String ... inAppStreamNames) {
            this.inAppStreamNames(Arrays.asList(inAppStreamNames));
        }

        public final KinesisStreamsInputDescription getKinesisStreamsInputDescription() {
            return this.kinesisStreamsInputDescription;
        }

        @Override
        public final Builder kinesisStreamsInputDescription(KinesisStreamsInputDescription kinesisStreamsInputDescription) {
            this.kinesisStreamsInputDescription = kinesisStreamsInputDescription;
            return this;
        }

        public final void setKinesisStreamsInputDescription(KinesisStreamsInputDescription kinesisStreamsInputDescription) {
            this.kinesisStreamsInputDescription = kinesisStreamsInputDescription;
        }

        public final KinesisFirehoseInputDescription getKinesisFirehoseInputDescription() {
            return this.kinesisFirehoseInputDescription;
        }

        @Override
        public final Builder kinesisFirehoseInputDescription(KinesisFirehoseInputDescription kinesisFirehoseInputDescription) {
            this.kinesisFirehoseInputDescription = kinesisFirehoseInputDescription;
            return this;
        }

        public final void setKinesisFirehoseInputDescription(KinesisFirehoseInputDescription kinesisFirehoseInputDescription) {
            this.kinesisFirehoseInputDescription = kinesisFirehoseInputDescription;
        }

        public final SourceSchema getInputSchema() {
            return this.inputSchema;
        }

        @Override
        public final Builder inputSchema(SourceSchema inputSchema) {
            this.inputSchema = inputSchema;
            return this;
        }

        public final void setInputSchema(SourceSchema inputSchema) {
            this.inputSchema = inputSchema;
        }

        public final InputParallelism getInputParallelism() {
            return this.inputParallelism;
        }

        @Override
        public final Builder inputParallelism(InputParallelism inputParallelism) {
            this.inputParallelism = inputParallelism;
            return this;
        }

        public final void setInputParallelism(InputParallelism inputParallelism) {
            this.inputParallelism = inputParallelism;
        }

        public final InputStartingPositionConfiguration getInputStartingPositionConfiguration() {
            return this.inputStartingPositionConfiguration;
        }

        @Override
        public final Builder inputStartingPositionConfiguration(InputStartingPositionConfiguration inputStartingPositionConfiguration) {
            this.inputStartingPositionConfiguration = inputStartingPositionConfiguration;
            return this;
        }

        public final void setInputStartingPositionConfiguration(InputStartingPositionConfiguration inputStartingPositionConfiguration) {
            this.inputStartingPositionConfiguration = inputStartingPositionConfiguration;
        }

        public InputDescription build() {
            return new InputDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InputDescription> {
        public Builder inputId(String var1);

        public Builder namePrefix(String var1);

        public Builder inAppStreamNames(Collection<String> var1);

        public Builder inAppStreamNames(String ... var1);

        public Builder kinesisStreamsInputDescription(KinesisStreamsInputDescription var1);

        public Builder kinesisFirehoseInputDescription(KinesisFirehoseInputDescription var1);

        public Builder inputSchema(SourceSchema var1);

        public Builder inputParallelism(InputParallelism var1);

        public Builder inputStartingPositionConfiguration(InputStartingPositionConfiguration var1);
    }
}

