/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteApplicationReferenceDataSourceRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DeleteApplicationReferenceDataSourceRequest> {
    private final String applicationName;
    private final Long currentApplicationVersionId;
    private final String referenceId;

    private DeleteApplicationReferenceDataSourceRequest(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.currentApplicationVersionId = builder.currentApplicationVersionId;
        this.referenceId = builder.referenceId;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public Long currentApplicationVersionId() {
        return this.currentApplicationVersionId;
    }

    public String referenceId() {
        return this.referenceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.applicationName() == null ? 0 : this.applicationName().hashCode());
        hashCode = 31 * hashCode + (this.currentApplicationVersionId() == null ? 0 : this.currentApplicationVersionId().hashCode());
        hashCode = 31 * hashCode + (this.referenceId() == null ? 0 : this.referenceId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteApplicationReferenceDataSourceRequest)) {
            return false;
        }
        DeleteApplicationReferenceDataSourceRequest other = (DeleteApplicationReferenceDataSourceRequest)((Object)obj);
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.currentApplicationVersionId() == null ^ this.currentApplicationVersionId() == null) {
            return false;
        }
        if (other.currentApplicationVersionId() != null && !other.currentApplicationVersionId().equals(this.currentApplicationVersionId())) {
            return false;
        }
        if (other.referenceId() == null ^ this.referenceId() == null) {
            return false;
        }
        return other.referenceId() == null || other.referenceId().equals(this.referenceId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.applicationName() != null) {
            sb.append("ApplicationName: ").append(this.applicationName()).append(",");
        }
        if (this.currentApplicationVersionId() != null) {
            sb.append("CurrentApplicationVersionId: ").append(this.currentApplicationVersionId()).append(",");
        }
        if (this.referenceId() != null) {
            sb.append("ReferenceId: ").append(this.referenceId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String applicationName;
        private Long currentApplicationVersionId;
        private String referenceId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteApplicationReferenceDataSourceRequest model) {
            this.setApplicationName(model.applicationName);
            this.setCurrentApplicationVersionId(model.currentApplicationVersionId);
            this.setReferenceId(model.referenceId);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final Long getCurrentApplicationVersionId() {
            return this.currentApplicationVersionId;
        }

        @Override
        public final Builder currentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
            return this;
        }

        public final void setCurrentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
        }

        public final String getReferenceId() {
            return this.referenceId;
        }

        @Override
        public final Builder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public final void setReferenceId(String referenceId) {
            this.referenceId = referenceId;
        }

        public DeleteApplicationReferenceDataSourceRequest build() {
            return new DeleteApplicationReferenceDataSourceRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteApplicationReferenceDataSourceRequest> {
        public Builder applicationName(String var1);

        public Builder currentApplicationVersionId(Long var1);

        public Builder referenceId(String var1);
    }
}

