/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.kinesisanalytics.model.CloudWatchLoggingOption;
import software.amazon.awssdk.services.kinesisanalytics.model.CloudWatchLoggingOptionsCopier;
import software.amazon.awssdk.services.kinesisanalytics.model.Input;
import software.amazon.awssdk.services.kinesisanalytics.model.InputsCopier;
import software.amazon.awssdk.services.kinesisanalytics.model.Output;
import software.amazon.awssdk.services.kinesisanalytics.model.OutputsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateApplicationRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateApplicationRequest> {
    private final String applicationName;
    private final String applicationDescription;
    private final List<Input> inputs;
    private final List<Output> outputs;
    private final List<CloudWatchLoggingOption> cloudWatchLoggingOptions;
    private final String applicationCode;

    private CreateApplicationRequest(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.applicationDescription = builder.applicationDescription;
        this.inputs = builder.inputs;
        this.outputs = builder.outputs;
        this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
        this.applicationCode = builder.applicationCode;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String applicationDescription() {
        return this.applicationDescription;
    }

    public List<Input> inputs() {
        return this.inputs;
    }

    public List<Output> outputs() {
        return this.outputs;
    }

    public List<CloudWatchLoggingOption> cloudWatchLoggingOptions() {
        return this.cloudWatchLoggingOptions;
    }

    public String applicationCode() {
        return this.applicationCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.applicationName() == null ? 0 : this.applicationName().hashCode());
        hashCode = 31 * hashCode + (this.applicationDescription() == null ? 0 : this.applicationDescription().hashCode());
        hashCode = 31 * hashCode + (this.inputs() == null ? 0 : this.inputs().hashCode());
        hashCode = 31 * hashCode + (this.outputs() == null ? 0 : this.outputs().hashCode());
        hashCode = 31 * hashCode + (this.cloudWatchLoggingOptions() == null ? 0 : this.cloudWatchLoggingOptions().hashCode());
        hashCode = 31 * hashCode + (this.applicationCode() == null ? 0 : this.applicationCode().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationRequest)) {
            return false;
        }
        CreateApplicationRequest other = (CreateApplicationRequest)((Object)obj);
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.applicationDescription() == null ^ this.applicationDescription() == null) {
            return false;
        }
        if (other.applicationDescription() != null && !other.applicationDescription().equals(this.applicationDescription())) {
            return false;
        }
        if (other.inputs() == null ^ this.inputs() == null) {
            return false;
        }
        if (other.inputs() != null && !other.inputs().equals(this.inputs())) {
            return false;
        }
        if (other.outputs() == null ^ this.outputs() == null) {
            return false;
        }
        if (other.outputs() != null && !other.outputs().equals(this.outputs())) {
            return false;
        }
        if (other.cloudWatchLoggingOptions() == null ^ this.cloudWatchLoggingOptions() == null) {
            return false;
        }
        if (other.cloudWatchLoggingOptions() != null && !other.cloudWatchLoggingOptions().equals(this.cloudWatchLoggingOptions())) {
            return false;
        }
        if (other.applicationCode() == null ^ this.applicationCode() == null) {
            return false;
        }
        return other.applicationCode() == null || other.applicationCode().equals(this.applicationCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.applicationName() != null) {
            sb.append("ApplicationName: ").append(this.applicationName()).append(",");
        }
        if (this.applicationDescription() != null) {
            sb.append("ApplicationDescription: ").append(this.applicationDescription()).append(",");
        }
        if (this.inputs() != null) {
            sb.append("Inputs: ").append(this.inputs()).append(",");
        }
        if (this.outputs() != null) {
            sb.append("Outputs: ").append(this.outputs()).append(",");
        }
        if (this.cloudWatchLoggingOptions() != null) {
            sb.append("CloudWatchLoggingOptions: ").append(this.cloudWatchLoggingOptions()).append(",");
        }
        if (this.applicationCode() != null) {
            sb.append("ApplicationCode: ").append(this.applicationCode()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String applicationName;
        private String applicationDescription;
        private List<Input> inputs;
        private List<Output> outputs;
        private List<CloudWatchLoggingOption> cloudWatchLoggingOptions;
        private String applicationCode;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApplicationRequest model) {
            this.setApplicationName(model.applicationName);
            this.setApplicationDescription(model.applicationDescription);
            this.setInputs(model.inputs);
            this.setOutputs(model.outputs);
            this.setCloudWatchLoggingOptions(model.cloudWatchLoggingOptions);
            this.setApplicationCode(model.applicationCode);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getApplicationDescription() {
            return this.applicationDescription;
        }

        @Override
        public final Builder applicationDescription(String applicationDescription) {
            this.applicationDescription = applicationDescription;
            return this;
        }

        public final void setApplicationDescription(String applicationDescription) {
            this.applicationDescription = applicationDescription;
        }

        public final Collection<Input> getInputs() {
            return this.inputs;
        }

        @Override
        public final Builder inputs(Collection<Input> inputs) {
            this.inputs = InputsCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(Input ... inputs) {
            this.inputs(Arrays.asList(inputs));
            return this;
        }

        public final void setInputs(Collection<Input> inputs) {
            this.inputs = InputsCopier.copy(inputs);
        }

        @SafeVarargs
        public final void setInputs(Input ... inputs) {
            this.inputs(Arrays.asList(inputs));
        }

        public final Collection<Output> getOutputs() {
            return this.outputs;
        }

        @Override
        public final Builder outputs(Collection<Output> outputs) {
            this.outputs = OutputsCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Output ... outputs) {
            this.outputs(Arrays.asList(outputs));
            return this;
        }

        public final void setOutputs(Collection<Output> outputs) {
            this.outputs = OutputsCopier.copy(outputs);
        }

        @SafeVarargs
        public final void setOutputs(Output ... outputs) {
            this.outputs(Arrays.asList(outputs));
        }

        public final Collection<CloudWatchLoggingOption> getCloudWatchLoggingOptions() {
            return this.cloudWatchLoggingOptions;
        }

        @Override
        public final Builder cloudWatchLoggingOptions(Collection<CloudWatchLoggingOption> cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = CloudWatchLoggingOptionsCopier.copy(cloudWatchLoggingOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchLoggingOptions(CloudWatchLoggingOption ... cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions(Arrays.asList(cloudWatchLoggingOptions));
            return this;
        }

        public final void setCloudWatchLoggingOptions(Collection<CloudWatchLoggingOption> cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = CloudWatchLoggingOptionsCopier.copy(cloudWatchLoggingOptions);
        }

        @SafeVarargs
        public final void setCloudWatchLoggingOptions(CloudWatchLoggingOption ... cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions(Arrays.asList(cloudWatchLoggingOptions));
        }

        public final String getApplicationCode() {
            return this.applicationCode;
        }

        @Override
        public final Builder applicationCode(String applicationCode) {
            this.applicationCode = applicationCode;
            return this;
        }

        public final void setApplicationCode(String applicationCode) {
            this.applicationCode = applicationCode;
        }

        public CreateApplicationRequest build() {
            return new CreateApplicationRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateApplicationRequest> {
        public Builder applicationName(String var1);

        public Builder applicationDescription(String var1);

        public Builder inputs(Collection<Input> var1);

        public Builder inputs(Input ... var1);

        public Builder outputs(Collection<Output> var1);

        public Builder outputs(Output ... var1);

        public Builder cloudWatchLoggingOptions(Collection<CloudWatchLoggingOption> var1);

        public Builder cloudWatchLoggingOptions(CloudWatchLoggingOption ... var1);

        public Builder applicationCode(String var1);
    }
}

