/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.model.CloudWatchLoggingOptionUpdate;
import software.amazon.awssdk.services.kinesisanalytics.model.CloudWatchLoggingOptionUpdatesCopier;
import software.amazon.awssdk.services.kinesisanalytics.model.InputUpdate;
import software.amazon.awssdk.services.kinesisanalytics.model.InputUpdatesCopier;
import software.amazon.awssdk.services.kinesisanalytics.model.OutputUpdate;
import software.amazon.awssdk.services.kinesisanalytics.model.OutputUpdatesCopier;
import software.amazon.awssdk.services.kinesisanalytics.model.ReferenceDataSourceUpdate;
import software.amazon.awssdk.services.kinesisanalytics.model.ReferenceDataSourceUpdatesCopier;
import software.amazon.awssdk.services.kinesisanalytics.transform.ApplicationUpdateMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ApplicationUpdate
implements StructuredPojo,
ToCopyableBuilder<Builder, ApplicationUpdate> {
    private final List<InputUpdate> inputUpdates;
    private final String applicationCodeUpdate;
    private final List<OutputUpdate> outputUpdates;
    private final List<ReferenceDataSourceUpdate> referenceDataSourceUpdates;
    private final List<CloudWatchLoggingOptionUpdate> cloudWatchLoggingOptionUpdates;

    private ApplicationUpdate(BuilderImpl builder) {
        this.inputUpdates = builder.inputUpdates;
        this.applicationCodeUpdate = builder.applicationCodeUpdate;
        this.outputUpdates = builder.outputUpdates;
        this.referenceDataSourceUpdates = builder.referenceDataSourceUpdates;
        this.cloudWatchLoggingOptionUpdates = builder.cloudWatchLoggingOptionUpdates;
    }

    public List<InputUpdate> inputUpdates() {
        return this.inputUpdates;
    }

    public String applicationCodeUpdate() {
        return this.applicationCodeUpdate;
    }

    public List<OutputUpdate> outputUpdates() {
        return this.outputUpdates;
    }

    public List<ReferenceDataSourceUpdate> referenceDataSourceUpdates() {
        return this.referenceDataSourceUpdates;
    }

    public List<CloudWatchLoggingOptionUpdate> cloudWatchLoggingOptionUpdates() {
        return this.cloudWatchLoggingOptionUpdates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.inputUpdates() == null ? 0 : this.inputUpdates().hashCode());
        hashCode = 31 * hashCode + (this.applicationCodeUpdate() == null ? 0 : this.applicationCodeUpdate().hashCode());
        hashCode = 31 * hashCode + (this.outputUpdates() == null ? 0 : this.outputUpdates().hashCode());
        hashCode = 31 * hashCode + (this.referenceDataSourceUpdates() == null ? 0 : this.referenceDataSourceUpdates().hashCode());
        hashCode = 31 * hashCode + (this.cloudWatchLoggingOptionUpdates() == null ? 0 : this.cloudWatchLoggingOptionUpdates().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationUpdate)) {
            return false;
        }
        ApplicationUpdate other = (ApplicationUpdate)obj;
        if (other.inputUpdates() == null ^ this.inputUpdates() == null) {
            return false;
        }
        if (other.inputUpdates() != null && !other.inputUpdates().equals(this.inputUpdates())) {
            return false;
        }
        if (other.applicationCodeUpdate() == null ^ this.applicationCodeUpdate() == null) {
            return false;
        }
        if (other.applicationCodeUpdate() != null && !other.applicationCodeUpdate().equals(this.applicationCodeUpdate())) {
            return false;
        }
        if (other.outputUpdates() == null ^ this.outputUpdates() == null) {
            return false;
        }
        if (other.outputUpdates() != null && !other.outputUpdates().equals(this.outputUpdates())) {
            return false;
        }
        if (other.referenceDataSourceUpdates() == null ^ this.referenceDataSourceUpdates() == null) {
            return false;
        }
        if (other.referenceDataSourceUpdates() != null && !other.referenceDataSourceUpdates().equals(this.referenceDataSourceUpdates())) {
            return false;
        }
        if (other.cloudWatchLoggingOptionUpdates() == null ^ this.cloudWatchLoggingOptionUpdates() == null) {
            return false;
        }
        return other.cloudWatchLoggingOptionUpdates() == null || other.cloudWatchLoggingOptionUpdates().equals(this.cloudWatchLoggingOptionUpdates());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.inputUpdates() != null) {
            sb.append("InputUpdates: ").append(this.inputUpdates()).append(",");
        }
        if (this.applicationCodeUpdate() != null) {
            sb.append("ApplicationCodeUpdate: ").append(this.applicationCodeUpdate()).append(",");
        }
        if (this.outputUpdates() != null) {
            sb.append("OutputUpdates: ").append(this.outputUpdates()).append(",");
        }
        if (this.referenceDataSourceUpdates() != null) {
            sb.append("ReferenceDataSourceUpdates: ").append(this.referenceDataSourceUpdates()).append(",");
        }
        if (this.cloudWatchLoggingOptionUpdates() != null) {
            sb.append("CloudWatchLoggingOptionUpdates: ").append(this.cloudWatchLoggingOptionUpdates()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ApplicationUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private List<InputUpdate> inputUpdates;
        private String applicationCodeUpdate;
        private List<OutputUpdate> outputUpdates;
        private List<ReferenceDataSourceUpdate> referenceDataSourceUpdates;
        private List<CloudWatchLoggingOptionUpdate> cloudWatchLoggingOptionUpdates;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationUpdate model) {
            this.setInputUpdates(model.inputUpdates);
            this.setApplicationCodeUpdate(model.applicationCodeUpdate);
            this.setOutputUpdates(model.outputUpdates);
            this.setReferenceDataSourceUpdates(model.referenceDataSourceUpdates);
            this.setCloudWatchLoggingOptionUpdates(model.cloudWatchLoggingOptionUpdates);
        }

        public final Collection<InputUpdate> getInputUpdates() {
            return this.inputUpdates;
        }

        @Override
        public final Builder inputUpdates(Collection<InputUpdate> inputUpdates) {
            this.inputUpdates = InputUpdatesCopier.copy(inputUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputUpdates(InputUpdate ... inputUpdates) {
            this.inputUpdates(Arrays.asList(inputUpdates));
            return this;
        }

        public final void setInputUpdates(Collection<InputUpdate> inputUpdates) {
            this.inputUpdates = InputUpdatesCopier.copy(inputUpdates);
        }

        @SafeVarargs
        public final void setInputUpdates(InputUpdate ... inputUpdates) {
            this.inputUpdates(Arrays.asList(inputUpdates));
        }

        public final String getApplicationCodeUpdate() {
            return this.applicationCodeUpdate;
        }

        @Override
        public final Builder applicationCodeUpdate(String applicationCodeUpdate) {
            this.applicationCodeUpdate = applicationCodeUpdate;
            return this;
        }

        public final void setApplicationCodeUpdate(String applicationCodeUpdate) {
            this.applicationCodeUpdate = applicationCodeUpdate;
        }

        public final Collection<OutputUpdate> getOutputUpdates() {
            return this.outputUpdates;
        }

        @Override
        public final Builder outputUpdates(Collection<OutputUpdate> outputUpdates) {
            this.outputUpdates = OutputUpdatesCopier.copy(outputUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputUpdates(OutputUpdate ... outputUpdates) {
            this.outputUpdates(Arrays.asList(outputUpdates));
            return this;
        }

        public final void setOutputUpdates(Collection<OutputUpdate> outputUpdates) {
            this.outputUpdates = OutputUpdatesCopier.copy(outputUpdates);
        }

        @SafeVarargs
        public final void setOutputUpdates(OutputUpdate ... outputUpdates) {
            this.outputUpdates(Arrays.asList(outputUpdates));
        }

        public final Collection<ReferenceDataSourceUpdate> getReferenceDataSourceUpdates() {
            return this.referenceDataSourceUpdates;
        }

        @Override
        public final Builder referenceDataSourceUpdates(Collection<ReferenceDataSourceUpdate> referenceDataSourceUpdates) {
            this.referenceDataSourceUpdates = ReferenceDataSourceUpdatesCopier.copy(referenceDataSourceUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceDataSourceUpdates(ReferenceDataSourceUpdate ... referenceDataSourceUpdates) {
            this.referenceDataSourceUpdates(Arrays.asList(referenceDataSourceUpdates));
            return this;
        }

        public final void setReferenceDataSourceUpdates(Collection<ReferenceDataSourceUpdate> referenceDataSourceUpdates) {
            this.referenceDataSourceUpdates = ReferenceDataSourceUpdatesCopier.copy(referenceDataSourceUpdates);
        }

        @SafeVarargs
        public final void setReferenceDataSourceUpdates(ReferenceDataSourceUpdate ... referenceDataSourceUpdates) {
            this.referenceDataSourceUpdates(Arrays.asList(referenceDataSourceUpdates));
        }

        public final Collection<CloudWatchLoggingOptionUpdate> getCloudWatchLoggingOptionUpdates() {
            return this.cloudWatchLoggingOptionUpdates;
        }

        @Override
        public final Builder cloudWatchLoggingOptionUpdates(Collection<CloudWatchLoggingOptionUpdate> cloudWatchLoggingOptionUpdates) {
            this.cloudWatchLoggingOptionUpdates = CloudWatchLoggingOptionUpdatesCopier.copy(cloudWatchLoggingOptionUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchLoggingOptionUpdates(CloudWatchLoggingOptionUpdate ... cloudWatchLoggingOptionUpdates) {
            this.cloudWatchLoggingOptionUpdates(Arrays.asList(cloudWatchLoggingOptionUpdates));
            return this;
        }

        public final void setCloudWatchLoggingOptionUpdates(Collection<CloudWatchLoggingOptionUpdate> cloudWatchLoggingOptionUpdates) {
            this.cloudWatchLoggingOptionUpdates = CloudWatchLoggingOptionUpdatesCopier.copy(cloudWatchLoggingOptionUpdates);
        }

        @SafeVarargs
        public final void setCloudWatchLoggingOptionUpdates(CloudWatchLoggingOptionUpdate ... cloudWatchLoggingOptionUpdates) {
            this.cloudWatchLoggingOptionUpdates(Arrays.asList(cloudWatchLoggingOptionUpdates));
        }

        public ApplicationUpdate build() {
            return new ApplicationUpdate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ApplicationUpdate> {
        public Builder inputUpdates(Collection<InputUpdate> var1);

        public Builder inputUpdates(InputUpdate ... var1);

        public Builder applicationCodeUpdate(String var1);

        public Builder outputUpdates(Collection<OutputUpdate> var1);

        public Builder outputUpdates(OutputUpdate ... var1);

        public Builder referenceDataSourceUpdates(Collection<ReferenceDataSourceUpdate> var1);

        public Builder referenceDataSourceUpdates(ReferenceDataSourceUpdate ... var1);

        public Builder cloudWatchLoggingOptionUpdates(Collection<CloudWatchLoggingOptionUpdate> var1);

        public Builder cloudWatchLoggingOptionUpdates(CloudWatchLoggingOptionUpdate ... var1);
    }
}

