/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics;

import java.net.URI;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.auth.Aws4Signer;
import software.amazon.awssdk.auth.Signer;
import software.amazon.awssdk.auth.StaticSignerProvider;
import software.amazon.awssdk.client.builder.ClientBuilder;
import software.amazon.awssdk.client.builder.DefaultClientBuilder;
import software.amazon.awssdk.config.defaults.ClientConfigurationDefaults;
import software.amazon.awssdk.config.defaults.ServiceBuilderConfigurationDefaults;
import software.amazon.awssdk.runtime.auth.SignerProvider;
import software.amazon.awssdk.services.kinesisanalytics.KinesisAnalyticsBaseClientBuilder;

@SdkInternalApi
abstract class DefaultKinesisAnalyticsBaseClientBuilder<B extends KinesisAnalyticsBaseClientBuilder<B, C>, C>
extends DefaultClientBuilder<B, C>
implements ClientBuilder<B, C> {
    DefaultKinesisAnalyticsBaseClientBuilder() {
    }

    protected final String serviceEndpointPrefix() {
        return "kinesisanalytics";
    }

    protected final ClientConfigurationDefaults serviceDefaults() {
        return ServiceBuilderConfigurationDefaults.builder().defaultSignerProvider(this::defaultSignerProvider).addRequestHandlerPath("/software/amazon/awssdk/services/kinesisanalytics/request.handler2s").defaultEndpoint(this::defaultEndpoint).build();
    }

    private SignerProvider defaultSignerProvider() {
        Aws4Signer signer = new Aws4Signer();
        signer.setServiceName("kinesisanalytics");
        signer.setRegionName(this.signingRegion().value());
        return new StaticSignerProvider((Signer)signer);
    }

    private URI defaultEndpoint() {
        return null;
    }
}

