/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesis.model.SplitShardRequest;

@SdkInternalApi
public class SplitShardRequestModelMarshaller {
    private static final MarshallingInfo<String> STREAMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamName").build();
    private static final MarshallingInfo<String> SHARDTOSPLIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ShardToSplit").build();
    private static final MarshallingInfo<String> NEWSTARTINGHASHKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NewStartingHashKey").build();
    private static final SplitShardRequestModelMarshaller instance = new SplitShardRequestModelMarshaller();

    public static SplitShardRequestModelMarshaller getInstance() {
        return instance;
    }

    public void marshall(SplitShardRequest splitShardRequest, ProtocolMarshaller protocolMarshaller) {
        if (splitShardRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)splitShardRequest.streamName(), STREAMNAME_BINDING);
            protocolMarshaller.marshall((Object)splitShardRequest.shardToSplit(), SHARDTOSPLIT_BINDING);
            protocolMarshaller.marshall((Object)splitShardRequest.newStartingHashKey(), NEWSTARTINGHASHKEY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

