/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListTagsForStreamRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListTagsForStreamRequest> {
    private final String streamName;
    private final String exclusiveStartTagKey;
    private final Integer limit;

    private ListTagsForStreamRequest(BuilderImpl builder) {
        this.streamName = builder.streamName;
        this.exclusiveStartTagKey = builder.exclusiveStartTagKey;
        this.limit = builder.limit;
    }

    public String streamName() {
        return this.streamName;
    }

    public String exclusiveStartTagKey() {
        return this.exclusiveStartTagKey;
    }

    public Integer limit() {
        return this.limit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.streamName() == null ? 0 : this.streamName().hashCode());
        hashCode = 31 * hashCode + (this.exclusiveStartTagKey() == null ? 0 : this.exclusiveStartTagKey().hashCode());
        hashCode = 31 * hashCode + (this.limit() == null ? 0 : this.limit().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsForStreamRequest)) {
            return false;
        }
        ListTagsForStreamRequest other = (ListTagsForStreamRequest)((Object)obj);
        if (other.streamName() == null ^ this.streamName() == null) {
            return false;
        }
        if (other.streamName() != null && !other.streamName().equals(this.streamName())) {
            return false;
        }
        if (other.exclusiveStartTagKey() == null ^ this.exclusiveStartTagKey() == null) {
            return false;
        }
        if (other.exclusiveStartTagKey() != null && !other.exclusiveStartTagKey().equals(this.exclusiveStartTagKey())) {
            return false;
        }
        if (other.limit() == null ^ this.limit() == null) {
            return false;
        }
        return other.limit() == null || other.limit().equals(this.limit());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.streamName() != null) {
            sb.append("StreamName: ").append(this.streamName()).append(",");
        }
        if (this.exclusiveStartTagKey() != null) {
            sb.append("ExclusiveStartTagKey: ").append(this.exclusiveStartTagKey()).append(",");
        }
        if (this.limit() != null) {
            sb.append("Limit: ").append(this.limit()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String streamName;
        private String exclusiveStartTagKey;
        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTagsForStreamRequest model) {
            this.setStreamName(model.streamName);
            this.setExclusiveStartTagKey(model.exclusiveStartTagKey);
            this.setLimit(model.limit);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final String getExclusiveStartTagKey() {
            return this.exclusiveStartTagKey;
        }

        @Override
        public final Builder exclusiveStartTagKey(String exclusiveStartTagKey) {
            this.exclusiveStartTagKey = exclusiveStartTagKey;
            return this;
        }

        public final void setExclusiveStartTagKey(String exclusiveStartTagKey) {
            this.exclusiveStartTagKey = exclusiveStartTagKey;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public ListTagsForStreamRequest build() {
            return new ListTagsForStreamRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListTagsForStreamRequest> {
        public Builder streamName(String var1);

        public Builder exclusiveStartTagKey(String var1);

        public Builder limit(Integer var1);
    }
}

