/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesis.model.MetricsName;
import software.amazon.awssdk.services.kinesis.model.MetricsNameListCopier;
import software.amazon.awssdk.services.kinesis.transform.EnhancedMetricsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EnhancedMetrics
implements StructuredPojo,
ToCopyableBuilder<Builder, EnhancedMetrics> {
    private final List<String> shardLevelMetrics;

    private EnhancedMetrics(BuilderImpl builder) {
        this.shardLevelMetrics = builder.shardLevelMetrics;
    }

    public List<String> shardLevelMetrics() {
        return this.shardLevelMetrics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.shardLevelMetrics() == null ? 0 : this.shardLevelMetrics().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnhancedMetrics)) {
            return false;
        }
        EnhancedMetrics other = (EnhancedMetrics)obj;
        if (other.shardLevelMetrics() == null ^ this.shardLevelMetrics() == null) {
            return false;
        }
        return other.shardLevelMetrics() == null || other.shardLevelMetrics().equals(this.shardLevelMetrics());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.shardLevelMetrics() != null) {
            sb.append("ShardLevelMetrics: ").append(this.shardLevelMetrics()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EnhancedMetricsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> shardLevelMetrics;

        private BuilderImpl() {
        }

        private BuilderImpl(EnhancedMetrics model) {
            this.setShardLevelMetrics(model.shardLevelMetrics);
        }

        public final Collection<String> getShardLevelMetrics() {
            return this.shardLevelMetrics;
        }

        @Override
        public final Builder shardLevelMetrics(Collection<String> shardLevelMetrics) {
            this.shardLevelMetrics = MetricsNameListCopier.copy(shardLevelMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shardLevelMetrics(String ... shardLevelMetrics) {
            this.shardLevelMetrics(Arrays.asList(shardLevelMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shardLevelMetrics(MetricsName ... shardLevelMetrics) {
            this.shardLevelMetrics(Arrays.asList(shardLevelMetrics).stream().map(Object::toString).collect(Collectors.toList()));
            return this;
        }

        public final void setShardLevelMetrics(Collection<String> shardLevelMetrics) {
            this.shardLevelMetrics = MetricsNameListCopier.copy(shardLevelMetrics);
        }

        @SafeVarargs
        public final void setShardLevelMetrics(String ... shardLevelMetrics) {
            this.shardLevelMetrics(Arrays.asList(shardLevelMetrics));
        }

        @SafeVarargs
        public final void setShardLevelMetrics(MetricsName ... shardLevelMetrics) {
            this.shardLevelMetrics(Arrays.asList(shardLevelMetrics).stream().map(Object::toString).collect(Collectors.toList()));
        }

        public EnhancedMetrics build() {
            return new EnhancedMetrics(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EnhancedMetrics> {
        public Builder shardLevelMetrics(Collection<String> var1);

        public Builder shardLevelMetrics(String ... var1);

        public Builder shardLevelMetrics(MetricsName ... var1);
    }
}

