/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.firehose.model.S3DestinationConfiguration;
import software.amazon.awssdk.services.firehose.transform.BufferingHintsUnmarshaller;
import software.amazon.awssdk.services.firehose.transform.CloudWatchLoggingOptionsUnmarshaller;
import software.amazon.awssdk.services.firehose.transform.EncryptionConfigurationUnmarshaller;

public class S3DestinationConfigurationUnmarshaller
implements Unmarshaller<S3DestinationConfiguration, JsonUnmarshallerContext> {
    private static S3DestinationConfigurationUnmarshaller INSTANCE;

    public S3DestinationConfiguration unmarshall(JsonUnmarshallerContext context) throws Exception {
        S3DestinationConfiguration.Builder s3DestinationConfigurationBuilder = S3DestinationConfiguration.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("RoleARN", targetDepth)) {
                    context.nextToken();
                    s3DestinationConfigurationBuilder.roleARN((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("BucketARN", targetDepth)) {
                    context.nextToken();
                    s3DestinationConfigurationBuilder.bucketARN((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Prefix", targetDepth)) {
                    context.nextToken();
                    s3DestinationConfigurationBuilder.prefix((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("BufferingHints", targetDepth)) {
                    context.nextToken();
                    s3DestinationConfigurationBuilder.bufferingHints(BufferingHintsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("CompressionFormat", targetDepth)) {
                    context.nextToken();
                    s3DestinationConfigurationBuilder.compressionFormat((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("EncryptionConfiguration", targetDepth)) {
                    context.nextToken();
                    s3DestinationConfigurationBuilder.encryptionConfiguration(EncryptionConfigurationUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("CloudWatchLoggingOptions", targetDepth)) {
                    context.nextToken();
                    s3DestinationConfigurationBuilder.cloudWatchLoggingOptions(CloudWatchLoggingOptionsUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (S3DestinationConfiguration)s3DestinationConfigurationBuilder.build();
    }

    public static S3DestinationConfigurationUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new S3DestinationConfigurationUnmarshaller();
        }
        return INSTANCE;
    }
}

