/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.model.ProcessorParameter;
import software.amazon.awssdk.services.firehose.model.ProcessorParameterListCopier;
import software.amazon.awssdk.services.firehose.model.ProcessorType;
import software.amazon.awssdk.services.firehose.transform.ProcessorMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Processor
implements StructuredPojo,
ToCopyableBuilder<Builder, Processor> {
    private final String type;
    private final List<ProcessorParameter> parameters;

    private Processor(BuilderImpl builder) {
        this.type = builder.type;
        this.parameters = builder.parameters;
    }

    public String type() {
        return this.type;
    }

    public List<ProcessorParameter> parameters() {
        return this.parameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.type() == null ? 0 : this.type().hashCode());
        hashCode = 31 * hashCode + (this.parameters() == null ? 0 : this.parameters().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Processor)) {
            return false;
        }
        Processor other = (Processor)obj;
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.parameters() == null ^ this.parameters() == null) {
            return false;
        }
        return other.parameters() == null || other.parameters().equals(this.parameters());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.type() != null) {
            sb.append("Type: ").append(this.type()).append(",");
        }
        if (this.parameters() != null) {
            sb.append("Parameters: ").append(this.parameters()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProcessorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String type;
        private List<ProcessorParameter> parameters;

        private BuilderImpl() {
        }

        private BuilderImpl(Processor model) {
            this.setType(model.type);
            this.setParameters(model.parameters);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ProcessorType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final void setType(ProcessorType type) {
            this.type(type.toString());
        }

        public final Collection<ProcessorParameter> getParameters() {
            return this.parameters;
        }

        @Override
        public final Builder parameters(Collection<ProcessorParameter> parameters) {
            this.parameters = ProcessorParameterListCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(ProcessorParameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        public final void setParameters(Collection<ProcessorParameter> parameters) {
            this.parameters = ProcessorParameterListCopier.copy(parameters);
        }

        @SafeVarargs
        public final void setParameters(ProcessorParameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
        }

        public Processor build() {
            return new Processor(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Processor> {
        public Builder type(String var1);

        public Builder type(ProcessorType var1);

        public Builder parameters(Collection<ProcessorParameter> var1);

        public Builder parameters(ProcessorParameter ... var1);
    }
}

