/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.model.BufferingHints;
import software.amazon.awssdk.services.firehose.model.CloudWatchLoggingOptions;
import software.amazon.awssdk.services.firehose.model.CompressionFormat;
import software.amazon.awssdk.services.firehose.model.EncryptionConfiguration;
import software.amazon.awssdk.services.firehose.model.ProcessingConfiguration;
import software.amazon.awssdk.services.firehose.model.S3BackupMode;
import software.amazon.awssdk.services.firehose.model.S3DestinationConfiguration;
import software.amazon.awssdk.services.firehose.transform.ExtendedS3DestinationConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ExtendedS3DestinationConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, ExtendedS3DestinationConfiguration> {
    private final String roleARN;
    private final String bucketARN;
    private final String prefix;
    private final BufferingHints bufferingHints;
    private final String compressionFormat;
    private final EncryptionConfiguration encryptionConfiguration;
    private final CloudWatchLoggingOptions cloudWatchLoggingOptions;
    private final ProcessingConfiguration processingConfiguration;
    private final String s3BackupMode;
    private final S3DestinationConfiguration s3BackupConfiguration;

    private ExtendedS3DestinationConfiguration(BuilderImpl builder) {
        this.roleARN = builder.roleARN;
        this.bucketARN = builder.bucketARN;
        this.prefix = builder.prefix;
        this.bufferingHints = builder.bufferingHints;
        this.compressionFormat = builder.compressionFormat;
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
        this.processingConfiguration = builder.processingConfiguration;
        this.s3BackupMode = builder.s3BackupMode;
        this.s3BackupConfiguration = builder.s3BackupConfiguration;
    }

    public String roleARN() {
        return this.roleARN;
    }

    public String bucketARN() {
        return this.bucketARN;
    }

    public String prefix() {
        return this.prefix;
    }

    public BufferingHints bufferingHints() {
        return this.bufferingHints;
    }

    public String compressionFormat() {
        return this.compressionFormat;
    }

    public EncryptionConfiguration encryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    public CloudWatchLoggingOptions cloudWatchLoggingOptions() {
        return this.cloudWatchLoggingOptions;
    }

    public ProcessingConfiguration processingConfiguration() {
        return this.processingConfiguration;
    }

    public String s3BackupMode() {
        return this.s3BackupMode;
    }

    public S3DestinationConfiguration s3BackupConfiguration() {
        return this.s3BackupConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.roleARN() == null ? 0 : this.roleARN().hashCode());
        hashCode = 31 * hashCode + (this.bucketARN() == null ? 0 : this.bucketARN().hashCode());
        hashCode = 31 * hashCode + (this.prefix() == null ? 0 : this.prefix().hashCode());
        hashCode = 31 * hashCode + (this.bufferingHints() == null ? 0 : this.bufferingHints().hashCode());
        hashCode = 31 * hashCode + (this.compressionFormat() == null ? 0 : this.compressionFormat().hashCode());
        hashCode = 31 * hashCode + (this.encryptionConfiguration() == null ? 0 : this.encryptionConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.cloudWatchLoggingOptions() == null ? 0 : this.cloudWatchLoggingOptions().hashCode());
        hashCode = 31 * hashCode + (this.processingConfiguration() == null ? 0 : this.processingConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.s3BackupMode() == null ? 0 : this.s3BackupMode().hashCode());
        hashCode = 31 * hashCode + (this.s3BackupConfiguration() == null ? 0 : this.s3BackupConfiguration().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExtendedS3DestinationConfiguration)) {
            return false;
        }
        ExtendedS3DestinationConfiguration other = (ExtendedS3DestinationConfiguration)obj;
        if (other.roleARN() == null ^ this.roleARN() == null) {
            return false;
        }
        if (other.roleARN() != null && !other.roleARN().equals(this.roleARN())) {
            return false;
        }
        if (other.bucketARN() == null ^ this.bucketARN() == null) {
            return false;
        }
        if (other.bucketARN() != null && !other.bucketARN().equals(this.bucketARN())) {
            return false;
        }
        if (other.prefix() == null ^ this.prefix() == null) {
            return false;
        }
        if (other.prefix() != null && !other.prefix().equals(this.prefix())) {
            return false;
        }
        if (other.bufferingHints() == null ^ this.bufferingHints() == null) {
            return false;
        }
        if (other.bufferingHints() != null && !other.bufferingHints().equals(this.bufferingHints())) {
            return false;
        }
        if (other.compressionFormat() == null ^ this.compressionFormat() == null) {
            return false;
        }
        if (other.compressionFormat() != null && !other.compressionFormat().equals(this.compressionFormat())) {
            return false;
        }
        if (other.encryptionConfiguration() == null ^ this.encryptionConfiguration() == null) {
            return false;
        }
        if (other.encryptionConfiguration() != null && !other.encryptionConfiguration().equals(this.encryptionConfiguration())) {
            return false;
        }
        if (other.cloudWatchLoggingOptions() == null ^ this.cloudWatchLoggingOptions() == null) {
            return false;
        }
        if (other.cloudWatchLoggingOptions() != null && !other.cloudWatchLoggingOptions().equals(this.cloudWatchLoggingOptions())) {
            return false;
        }
        if (other.processingConfiguration() == null ^ this.processingConfiguration() == null) {
            return false;
        }
        if (other.processingConfiguration() != null && !other.processingConfiguration().equals(this.processingConfiguration())) {
            return false;
        }
        if (other.s3BackupMode() == null ^ this.s3BackupMode() == null) {
            return false;
        }
        if (other.s3BackupMode() != null && !other.s3BackupMode().equals(this.s3BackupMode())) {
            return false;
        }
        if (other.s3BackupConfiguration() == null ^ this.s3BackupConfiguration() == null) {
            return false;
        }
        return other.s3BackupConfiguration() == null || other.s3BackupConfiguration().equals(this.s3BackupConfiguration());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.roleARN() != null) {
            sb.append("RoleARN: ").append(this.roleARN()).append(",");
        }
        if (this.bucketARN() != null) {
            sb.append("BucketARN: ").append(this.bucketARN()).append(",");
        }
        if (this.prefix() != null) {
            sb.append("Prefix: ").append(this.prefix()).append(",");
        }
        if (this.bufferingHints() != null) {
            sb.append("BufferingHints: ").append(this.bufferingHints()).append(",");
        }
        if (this.compressionFormat() != null) {
            sb.append("CompressionFormat: ").append(this.compressionFormat()).append(",");
        }
        if (this.encryptionConfiguration() != null) {
            sb.append("EncryptionConfiguration: ").append(this.encryptionConfiguration()).append(",");
        }
        if (this.cloudWatchLoggingOptions() != null) {
            sb.append("CloudWatchLoggingOptions: ").append(this.cloudWatchLoggingOptions()).append(",");
        }
        if (this.processingConfiguration() != null) {
            sb.append("ProcessingConfiguration: ").append(this.processingConfiguration()).append(",");
        }
        if (this.s3BackupMode() != null) {
            sb.append("S3BackupMode: ").append(this.s3BackupMode()).append(",");
        }
        if (this.s3BackupConfiguration() != null) {
            sb.append("S3BackupConfiguration: ").append(this.s3BackupConfiguration()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ExtendedS3DestinationConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String roleARN;
        private String bucketARN;
        private String prefix;
        private BufferingHints bufferingHints;
        private String compressionFormat;
        private EncryptionConfiguration encryptionConfiguration;
        private CloudWatchLoggingOptions cloudWatchLoggingOptions;
        private ProcessingConfiguration processingConfiguration;
        private String s3BackupMode;
        private S3DestinationConfiguration s3BackupConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ExtendedS3DestinationConfiguration model) {
            this.setRoleARN(model.roleARN);
            this.setBucketARN(model.bucketARN);
            this.setPrefix(model.prefix);
            this.setBufferingHints(model.bufferingHints);
            this.setCompressionFormat(model.compressionFormat);
            this.setEncryptionConfiguration(model.encryptionConfiguration);
            this.setCloudWatchLoggingOptions(model.cloudWatchLoggingOptions);
            this.setProcessingConfiguration(model.processingConfiguration);
            this.setS3BackupMode(model.s3BackupMode);
            this.setS3BackupConfiguration(model.s3BackupConfiguration);
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final String getBucketARN() {
            return this.bucketARN;
        }

        @Override
        public final Builder bucketARN(String bucketARN) {
            this.bucketARN = bucketARN;
            return this;
        }

        public final void setBucketARN(String bucketARN) {
            this.bucketARN = bucketARN;
        }

        public final String getPrefix() {
            return this.prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final BufferingHints getBufferingHints() {
            return this.bufferingHints;
        }

        @Override
        public final Builder bufferingHints(BufferingHints bufferingHints) {
            this.bufferingHints = bufferingHints;
            return this;
        }

        public final void setBufferingHints(BufferingHints bufferingHints) {
            this.bufferingHints = bufferingHints;
        }

        public final String getCompressionFormat() {
            return this.compressionFormat;
        }

        @Override
        public final Builder compressionFormat(String compressionFormat) {
            this.compressionFormat = compressionFormat;
            return this;
        }

        @Override
        public final Builder compressionFormat(CompressionFormat compressionFormat) {
            this.compressionFormat(compressionFormat.toString());
            return this;
        }

        public final void setCompressionFormat(String compressionFormat) {
            this.compressionFormat = compressionFormat;
        }

        public final void setCompressionFormat(CompressionFormat compressionFormat) {
            this.compressionFormat(compressionFormat.toString());
        }

        public final EncryptionConfiguration getEncryptionConfiguration() {
            return this.encryptionConfiguration;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
        }

        public final CloudWatchLoggingOptions getCloudWatchLoggingOptions() {
            return this.cloudWatchLoggingOptions;
        }

        @Override
        public final Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
            return this;
        }

        public final void setCloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
        }

        public final ProcessingConfiguration getProcessingConfiguration() {
            return this.processingConfiguration;
        }

        @Override
        public final Builder processingConfiguration(ProcessingConfiguration processingConfiguration) {
            this.processingConfiguration = processingConfiguration;
            return this;
        }

        public final void setProcessingConfiguration(ProcessingConfiguration processingConfiguration) {
            this.processingConfiguration = processingConfiguration;
        }

        public final String getS3BackupMode() {
            return this.s3BackupMode;
        }

        @Override
        public final Builder s3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
            return this;
        }

        @Override
        public final Builder s3BackupMode(S3BackupMode s3BackupMode) {
            this.s3BackupMode(s3BackupMode.toString());
            return this;
        }

        public final void setS3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
        }

        public final void setS3BackupMode(S3BackupMode s3BackupMode) {
            this.s3BackupMode(s3BackupMode.toString());
        }

        public final S3DestinationConfiguration getS3BackupConfiguration() {
            return this.s3BackupConfiguration;
        }

        @Override
        public final Builder s3BackupConfiguration(S3DestinationConfiguration s3BackupConfiguration) {
            this.s3BackupConfiguration = s3BackupConfiguration;
            return this;
        }

        public final void setS3BackupConfiguration(S3DestinationConfiguration s3BackupConfiguration) {
            this.s3BackupConfiguration = s3BackupConfiguration;
        }

        public ExtendedS3DestinationConfiguration build() {
            return new ExtendedS3DestinationConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ExtendedS3DestinationConfiguration> {
        public Builder roleARN(String var1);

        public Builder bucketARN(String var1);

        public Builder prefix(String var1);

        public Builder bufferingHints(BufferingHints var1);

        public Builder compressionFormat(String var1);

        public Builder compressionFormat(CompressionFormat var1);

        public Builder encryptionConfiguration(EncryptionConfiguration var1);

        public Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions var1);

        public Builder processingConfiguration(ProcessingConfiguration var1);

        public Builder s3BackupMode(String var1);

        public Builder s3BackupMode(S3BackupMode var1);

        public Builder s3BackupConfiguration(S3DestinationConfiguration var1);
    }
}

