/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.model.ElasticsearchDestinationDescription;
import software.amazon.awssdk.services.firehose.model.ExtendedS3DestinationDescription;
import software.amazon.awssdk.services.firehose.model.RedshiftDestinationDescription;
import software.amazon.awssdk.services.firehose.model.S3DestinationDescription;
import software.amazon.awssdk.services.firehose.transform.DestinationDescriptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DestinationDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, DestinationDescription> {
    private final String destinationId;
    private final S3DestinationDescription s3DestinationDescription;
    private final ExtendedS3DestinationDescription extendedS3DestinationDescription;
    private final RedshiftDestinationDescription redshiftDestinationDescription;
    private final ElasticsearchDestinationDescription elasticsearchDestinationDescription;

    private DestinationDescription(BuilderImpl builder) {
        this.destinationId = builder.destinationId;
        this.s3DestinationDescription = builder.s3DestinationDescription;
        this.extendedS3DestinationDescription = builder.extendedS3DestinationDescription;
        this.redshiftDestinationDescription = builder.redshiftDestinationDescription;
        this.elasticsearchDestinationDescription = builder.elasticsearchDestinationDescription;
    }

    public String destinationId() {
        return this.destinationId;
    }

    public S3DestinationDescription s3DestinationDescription() {
        return this.s3DestinationDescription;
    }

    public ExtendedS3DestinationDescription extendedS3DestinationDescription() {
        return this.extendedS3DestinationDescription;
    }

    public RedshiftDestinationDescription redshiftDestinationDescription() {
        return this.redshiftDestinationDescription;
    }

    public ElasticsearchDestinationDescription elasticsearchDestinationDescription() {
        return this.elasticsearchDestinationDescription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.destinationId() == null ? 0 : this.destinationId().hashCode());
        hashCode = 31 * hashCode + (this.s3DestinationDescription() == null ? 0 : this.s3DestinationDescription().hashCode());
        hashCode = 31 * hashCode + (this.extendedS3DestinationDescription() == null ? 0 : this.extendedS3DestinationDescription().hashCode());
        hashCode = 31 * hashCode + (this.redshiftDestinationDescription() == null ? 0 : this.redshiftDestinationDescription().hashCode());
        hashCode = 31 * hashCode + (this.elasticsearchDestinationDescription() == null ? 0 : this.elasticsearchDestinationDescription().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DestinationDescription)) {
            return false;
        }
        DestinationDescription other = (DestinationDescription)obj;
        if (other.destinationId() == null ^ this.destinationId() == null) {
            return false;
        }
        if (other.destinationId() != null && !other.destinationId().equals(this.destinationId())) {
            return false;
        }
        if (other.s3DestinationDescription() == null ^ this.s3DestinationDescription() == null) {
            return false;
        }
        if (other.s3DestinationDescription() != null && !other.s3DestinationDescription().equals(this.s3DestinationDescription())) {
            return false;
        }
        if (other.extendedS3DestinationDescription() == null ^ this.extendedS3DestinationDescription() == null) {
            return false;
        }
        if (other.extendedS3DestinationDescription() != null && !other.extendedS3DestinationDescription().equals(this.extendedS3DestinationDescription())) {
            return false;
        }
        if (other.redshiftDestinationDescription() == null ^ this.redshiftDestinationDescription() == null) {
            return false;
        }
        if (other.redshiftDestinationDescription() != null && !other.redshiftDestinationDescription().equals(this.redshiftDestinationDescription())) {
            return false;
        }
        if (other.elasticsearchDestinationDescription() == null ^ this.elasticsearchDestinationDescription() == null) {
            return false;
        }
        return other.elasticsearchDestinationDescription() == null || other.elasticsearchDestinationDescription().equals(this.elasticsearchDestinationDescription());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.destinationId() != null) {
            sb.append("DestinationId: ").append(this.destinationId()).append(",");
        }
        if (this.s3DestinationDescription() != null) {
            sb.append("S3DestinationDescription: ").append(this.s3DestinationDescription()).append(",");
        }
        if (this.extendedS3DestinationDescription() != null) {
            sb.append("ExtendedS3DestinationDescription: ").append(this.extendedS3DestinationDescription()).append(",");
        }
        if (this.redshiftDestinationDescription() != null) {
            sb.append("RedshiftDestinationDescription: ").append(this.redshiftDestinationDescription()).append(",");
        }
        if (this.elasticsearchDestinationDescription() != null) {
            sb.append("ElasticsearchDestinationDescription: ").append(this.elasticsearchDestinationDescription()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DestinationDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String destinationId;
        private S3DestinationDescription s3DestinationDescription;
        private ExtendedS3DestinationDescription extendedS3DestinationDescription;
        private RedshiftDestinationDescription redshiftDestinationDescription;
        private ElasticsearchDestinationDescription elasticsearchDestinationDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(DestinationDescription model) {
            this.setDestinationId(model.destinationId);
            this.setS3DestinationDescription(model.s3DestinationDescription);
            this.setExtendedS3DestinationDescription(model.extendedS3DestinationDescription);
            this.setRedshiftDestinationDescription(model.redshiftDestinationDescription);
            this.setElasticsearchDestinationDescription(model.elasticsearchDestinationDescription);
        }

        public final String getDestinationId() {
            return this.destinationId;
        }

        @Override
        public final Builder destinationId(String destinationId) {
            this.destinationId = destinationId;
            return this;
        }

        public final void setDestinationId(String destinationId) {
            this.destinationId = destinationId;
        }

        public final S3DestinationDescription getS3DestinationDescription() {
            return this.s3DestinationDescription;
        }

        @Override
        public final Builder s3DestinationDescription(S3DestinationDescription s3DestinationDescription) {
            this.s3DestinationDescription = s3DestinationDescription;
            return this;
        }

        public final void setS3DestinationDescription(S3DestinationDescription s3DestinationDescription) {
            this.s3DestinationDescription = s3DestinationDescription;
        }

        public final ExtendedS3DestinationDescription getExtendedS3DestinationDescription() {
            return this.extendedS3DestinationDescription;
        }

        @Override
        public final Builder extendedS3DestinationDescription(ExtendedS3DestinationDescription extendedS3DestinationDescription) {
            this.extendedS3DestinationDescription = extendedS3DestinationDescription;
            return this;
        }

        public final void setExtendedS3DestinationDescription(ExtendedS3DestinationDescription extendedS3DestinationDescription) {
            this.extendedS3DestinationDescription = extendedS3DestinationDescription;
        }

        public final RedshiftDestinationDescription getRedshiftDestinationDescription() {
            return this.redshiftDestinationDescription;
        }

        @Override
        public final Builder redshiftDestinationDescription(RedshiftDestinationDescription redshiftDestinationDescription) {
            this.redshiftDestinationDescription = redshiftDestinationDescription;
            return this;
        }

        public final void setRedshiftDestinationDescription(RedshiftDestinationDescription redshiftDestinationDescription) {
            this.redshiftDestinationDescription = redshiftDestinationDescription;
        }

        public final ElasticsearchDestinationDescription getElasticsearchDestinationDescription() {
            return this.elasticsearchDestinationDescription;
        }

        @Override
        public final Builder elasticsearchDestinationDescription(ElasticsearchDestinationDescription elasticsearchDestinationDescription) {
            this.elasticsearchDestinationDescription = elasticsearchDestinationDescription;
            return this;
        }

        public final void setElasticsearchDestinationDescription(ElasticsearchDestinationDescription elasticsearchDestinationDescription) {
            this.elasticsearchDestinationDescription = elasticsearchDestinationDescription;
        }

        public DestinationDescription build() {
            return new DestinationDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DestinationDescription> {
        public Builder destinationId(String var1);

        public Builder s3DestinationDescription(S3DestinationDescription var1);

        public Builder extendedS3DestinationDescription(ExtendedS3DestinationDescription var1);

        public Builder redshiftDestinationDescription(RedshiftDestinationDescription var1);

        public Builder elasticsearchDestinationDescription(ElasticsearchDestinationDescription var1);
    }
}

