/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.transform.CloudWatchLoggingOptionsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CloudWatchLoggingOptions
implements StructuredPojo,
ToCopyableBuilder<Builder, CloudWatchLoggingOptions> {
    private final Boolean enabled;
    private final String logGroupName;
    private final String logStreamName;

    private CloudWatchLoggingOptions(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.logGroupName = builder.logGroupName;
        this.logStreamName = builder.logStreamName;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public String logGroupName() {
        return this.logGroupName;
    }

    public String logStreamName() {
        return this.logStreamName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.enabled() == null ? 0 : this.enabled().hashCode());
        hashCode = 31 * hashCode + (this.logGroupName() == null ? 0 : this.logGroupName().hashCode());
        hashCode = 31 * hashCode + (this.logStreamName() == null ? 0 : this.logStreamName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchLoggingOptions)) {
            return false;
        }
        CloudWatchLoggingOptions other = (CloudWatchLoggingOptions)obj;
        if (other.enabled() == null ^ this.enabled() == null) {
            return false;
        }
        if (other.enabled() != null && !other.enabled().equals(this.enabled())) {
            return false;
        }
        if (other.logGroupName() == null ^ this.logGroupName() == null) {
            return false;
        }
        if (other.logGroupName() != null && !other.logGroupName().equals(this.logGroupName())) {
            return false;
        }
        if (other.logStreamName() == null ^ this.logStreamName() == null) {
            return false;
        }
        return other.logStreamName() == null || other.logStreamName().equals(this.logStreamName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.enabled() != null) {
            sb.append("Enabled: ").append(this.enabled()).append(",");
        }
        if (this.logGroupName() != null) {
            sb.append("LogGroupName: ").append(this.logGroupName()).append(",");
        }
        if (this.logStreamName() != null) {
            sb.append("LogStreamName: ").append(this.logStreamName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CloudWatchLoggingOptionsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private String logGroupName;
        private String logStreamName;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchLoggingOptions model) {
            this.setEnabled(model.enabled);
            this.setLogGroupName(model.logGroupName);
            this.setLogStreamName(model.logStreamName);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public final String getLogStreamName() {
            return this.logStreamName;
        }

        @Override
        public final Builder logStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
            return this;
        }

        public final void setLogStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
        }

        public CloudWatchLoggingOptions build() {
            return new CloudWatchLoggingOptions(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CloudWatchLoggingOptions> {
        public Builder enabled(Boolean var1);

        public Builder logGroupName(String var1);

        public Builder logStreamName(String var1);
    }
}

