/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.keyspaces;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.keyspaces.DefaultKeyspacesAsyncClientBuilder;
import software.amazon.awssdk.services.keyspaces.KeyspacesAsyncClientBuilder;
import software.amazon.awssdk.services.keyspaces.KeyspacesServiceClientConfiguration;
import software.amazon.awssdk.services.keyspaces.model.CreateKeyspaceRequest;
import software.amazon.awssdk.services.keyspaces.model.CreateKeyspaceResponse;
import software.amazon.awssdk.services.keyspaces.model.CreateTableRequest;
import software.amazon.awssdk.services.keyspaces.model.CreateTableResponse;
import software.amazon.awssdk.services.keyspaces.model.DeleteKeyspaceRequest;
import software.amazon.awssdk.services.keyspaces.model.DeleteKeyspaceResponse;
import software.amazon.awssdk.services.keyspaces.model.DeleteTableRequest;
import software.amazon.awssdk.services.keyspaces.model.DeleteTableResponse;
import software.amazon.awssdk.services.keyspaces.model.GetKeyspaceRequest;
import software.amazon.awssdk.services.keyspaces.model.GetKeyspaceResponse;
import software.amazon.awssdk.services.keyspaces.model.GetTableRequest;
import software.amazon.awssdk.services.keyspaces.model.GetTableResponse;
import software.amazon.awssdk.services.keyspaces.model.ListKeyspacesRequest;
import software.amazon.awssdk.services.keyspaces.model.ListKeyspacesResponse;
import software.amazon.awssdk.services.keyspaces.model.ListTablesRequest;
import software.amazon.awssdk.services.keyspaces.model.ListTablesResponse;
import software.amazon.awssdk.services.keyspaces.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.keyspaces.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.keyspaces.model.RestoreTableRequest;
import software.amazon.awssdk.services.keyspaces.model.RestoreTableResponse;
import software.amazon.awssdk.services.keyspaces.model.TagResourceRequest;
import software.amazon.awssdk.services.keyspaces.model.TagResourceResponse;
import software.amazon.awssdk.services.keyspaces.model.UntagResourceRequest;
import software.amazon.awssdk.services.keyspaces.model.UntagResourceResponse;
import software.amazon.awssdk.services.keyspaces.model.UpdateTableRequest;
import software.amazon.awssdk.services.keyspaces.model.UpdateTableResponse;
import software.amazon.awssdk.services.keyspaces.paginators.ListKeyspacesPublisher;
import software.amazon.awssdk.services.keyspaces.paginators.ListTablesPublisher;
import software.amazon.awssdk.services.keyspaces.paginators.ListTagsForResourcePublisher;

@SdkPublicApi
@ThreadSafe
public interface KeyspacesAsyncClient
extends AwsClient {
    public static final String SERVICE_NAME = "cassandra";
    public static final String SERVICE_METADATA_ID = "cassandra";

    default public CompletableFuture<CreateKeyspaceResponse> createKeyspace(CreateKeyspaceRequest createKeyspaceRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<CreateKeyspaceResponse> createKeyspace(Consumer<CreateKeyspaceRequest.Builder> createKeyspaceRequest) {
        return this.createKeyspace((CreateKeyspaceRequest)((Object)((CreateKeyspaceRequest.Builder)CreateKeyspaceRequest.builder().applyMutation(createKeyspaceRequest)).build()));
    }

    default public CompletableFuture<CreateTableResponse> createTable(CreateTableRequest createTableRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<CreateTableResponse> createTable(Consumer<CreateTableRequest.Builder> createTableRequest) {
        return this.createTable((CreateTableRequest)((Object)((CreateTableRequest.Builder)CreateTableRequest.builder().applyMutation(createTableRequest)).build()));
    }

    default public CompletableFuture<DeleteKeyspaceResponse> deleteKeyspace(DeleteKeyspaceRequest deleteKeyspaceRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DeleteKeyspaceResponse> deleteKeyspace(Consumer<DeleteKeyspaceRequest.Builder> deleteKeyspaceRequest) {
        return this.deleteKeyspace((DeleteKeyspaceRequest)((Object)((DeleteKeyspaceRequest.Builder)DeleteKeyspaceRequest.builder().applyMutation(deleteKeyspaceRequest)).build()));
    }

    default public CompletableFuture<DeleteTableResponse> deleteTable(DeleteTableRequest deleteTableRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DeleteTableResponse> deleteTable(Consumer<DeleteTableRequest.Builder> deleteTableRequest) {
        return this.deleteTable((DeleteTableRequest)((Object)((DeleteTableRequest.Builder)DeleteTableRequest.builder().applyMutation(deleteTableRequest)).build()));
    }

    default public CompletableFuture<GetKeyspaceResponse> getKeyspace(GetKeyspaceRequest getKeyspaceRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetKeyspaceResponse> getKeyspace(Consumer<GetKeyspaceRequest.Builder> getKeyspaceRequest) {
        return this.getKeyspace((GetKeyspaceRequest)((Object)((GetKeyspaceRequest.Builder)GetKeyspaceRequest.builder().applyMutation(getKeyspaceRequest)).build()));
    }

    default public CompletableFuture<GetTableResponse> getTable(GetTableRequest getTableRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetTableResponse> getTable(Consumer<GetTableRequest.Builder> getTableRequest) {
        return this.getTable((GetTableRequest)((Object)((GetTableRequest.Builder)GetTableRequest.builder().applyMutation(getTableRequest)).build()));
    }

    default public CompletableFuture<ListKeyspacesResponse> listKeyspaces(ListKeyspacesRequest listKeyspacesRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListKeyspacesResponse> listKeyspaces(Consumer<ListKeyspacesRequest.Builder> listKeyspacesRequest) {
        return this.listKeyspaces((ListKeyspacesRequest)((Object)((ListKeyspacesRequest.Builder)ListKeyspacesRequest.builder().applyMutation(listKeyspacesRequest)).build()));
    }

    default public ListKeyspacesPublisher listKeyspacesPaginator(ListKeyspacesRequest listKeyspacesRequest) {
        throw new UnsupportedOperationException();
    }

    default public ListKeyspacesPublisher listKeyspacesPaginator(Consumer<ListKeyspacesRequest.Builder> listKeyspacesRequest) {
        return this.listKeyspacesPaginator((ListKeyspacesRequest)((Object)((ListKeyspacesRequest.Builder)ListKeyspacesRequest.builder().applyMutation(listKeyspacesRequest)).build()));
    }

    default public CompletableFuture<ListTablesResponse> listTables(ListTablesRequest listTablesRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListTablesResponse> listTables(Consumer<ListTablesRequest.Builder> listTablesRequest) {
        return this.listTables((ListTablesRequest)((Object)((ListTablesRequest.Builder)ListTablesRequest.builder().applyMutation(listTablesRequest)).build()));
    }

    default public ListTablesPublisher listTablesPaginator(ListTablesRequest listTablesRequest) {
        throw new UnsupportedOperationException();
    }

    default public ListTablesPublisher listTablesPaginator(Consumer<ListTablesRequest.Builder> listTablesRequest) {
        return this.listTablesPaginator((ListTablesRequest)((Object)((ListTablesRequest.Builder)ListTablesRequest.builder().applyMutation(listTablesRequest)).build()));
    }

    default public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return this.listTagsForResource((ListTagsForResourceRequest)((Object)((ListTagsForResourceRequest.Builder)ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)).build()));
    }

    default public ListTagsForResourcePublisher listTagsForResourcePaginator(ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    default public ListTagsForResourcePublisher listTagsForResourcePaginator(Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return this.listTagsForResourcePaginator((ListTagsForResourceRequest)((Object)((ListTagsForResourceRequest.Builder)ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)).build()));
    }

    default public CompletableFuture<RestoreTableResponse> restoreTable(RestoreTableRequest restoreTableRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<RestoreTableResponse> restoreTable(Consumer<RestoreTableRequest.Builder> restoreTableRequest) {
        return this.restoreTable((RestoreTableRequest)((Object)((RestoreTableRequest.Builder)RestoreTableRequest.builder().applyMutation(restoreTableRequest)).build()));
    }

    default public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return this.tagResource((TagResourceRequest)((Object)((TagResourceRequest.Builder)TagResourceRequest.builder().applyMutation(tagResourceRequest)).build()));
    }

    default public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return this.untagResource((UntagResourceRequest)((Object)((UntagResourceRequest.Builder)UntagResourceRequest.builder().applyMutation(untagResourceRequest)).build()));
    }

    default public CompletableFuture<UpdateTableResponse> updateTable(UpdateTableRequest updateTableRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<UpdateTableResponse> updateTable(Consumer<UpdateTableRequest.Builder> updateTableRequest) {
        return this.updateTable((UpdateTableRequest)((Object)((UpdateTableRequest.Builder)UpdateTableRequest.builder().applyMutation(updateTableRequest)).build()));
    }

    default public KeyspacesServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    public static KeyspacesAsyncClient create() {
        return (KeyspacesAsyncClient)KeyspacesAsyncClient.builder().build();
    }

    public static KeyspacesAsyncClientBuilder builder() {
        return new DefaultKeyspacesAsyncClientBuilder();
    }
}

