/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kendra.model.DocumentAttributeCondition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HookConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HookConfiguration> {
    private static final SdkField<DocumentAttributeCondition> INVOCATION_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InvocationCondition").getter(HookConfiguration.getter(HookConfiguration::invocationCondition)).setter(HookConfiguration.setter(Builder::invocationCondition)).constructor(DocumentAttributeCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvocationCondition").build()}).build();
    private static final SdkField<String> LAMBDA_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LambdaArn").getter(HookConfiguration.getter(HookConfiguration::lambdaArn)).setter(HookConfiguration.setter(Builder::lambdaArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaArn").build()}).build();
    private static final SdkField<String> S3_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Bucket").getter(HookConfiguration.getter(HookConfiguration::s3Bucket)).setter(HookConfiguration.setter(Builder::s3Bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Bucket").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVOCATION_CONDITION_FIELD, LAMBDA_ARN_FIELD, S3_BUCKET_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = HookConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final DocumentAttributeCondition invocationCondition;
    private final String lambdaArn;
    private final String s3Bucket;

    private HookConfiguration(BuilderImpl builder) {
        this.invocationCondition = builder.invocationCondition;
        this.lambdaArn = builder.lambdaArn;
        this.s3Bucket = builder.s3Bucket;
    }

    public final DocumentAttributeCondition invocationCondition() {
        return this.invocationCondition;
    }

    public final String lambdaArn() {
        return this.lambdaArn;
    }

    public final String s3Bucket() {
        return this.s3Bucket;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.invocationCondition());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Bucket());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HookConfiguration)) {
            return false;
        }
        HookConfiguration other = (HookConfiguration)obj;
        return Objects.equals(this.invocationCondition(), other.invocationCondition()) && Objects.equals(this.lambdaArn(), other.lambdaArn()) && Objects.equals(this.s3Bucket(), other.s3Bucket());
    }

    public final String toString() {
        return ToString.builder((String)"HookConfiguration").add("InvocationCondition", (Object)this.invocationCondition()).add("LambdaArn", (Object)this.lambdaArn()).add("S3Bucket", (Object)this.s3Bucket()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InvocationCondition": {
                return Optional.ofNullable(clazz.cast(this.invocationCondition()));
            }
            case "LambdaArn": {
                return Optional.ofNullable(clazz.cast(this.lambdaArn()));
            }
            case "S3Bucket": {
                return Optional.ofNullable(clazz.cast(this.s3Bucket()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InvocationCondition", INVOCATION_CONDITION_FIELD);
        map.put("LambdaArn", LAMBDA_ARN_FIELD);
        map.put("S3Bucket", S3_BUCKET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HookConfiguration, T> g) {
        return obj -> g.apply((HookConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DocumentAttributeCondition invocationCondition;
        private String lambdaArn;
        private String s3Bucket;

        private BuilderImpl() {
        }

        private BuilderImpl(HookConfiguration model) {
            this.invocationCondition(model.invocationCondition);
            this.lambdaArn(model.lambdaArn);
            this.s3Bucket(model.s3Bucket);
        }

        public final DocumentAttributeCondition.Builder getInvocationCondition() {
            return this.invocationCondition != null ? this.invocationCondition.toBuilder() : null;
        }

        public final void setInvocationCondition(DocumentAttributeCondition.BuilderImpl invocationCondition) {
            this.invocationCondition = invocationCondition != null ? invocationCondition.build() : null;
        }

        @Override
        public final Builder invocationCondition(DocumentAttributeCondition invocationCondition) {
            this.invocationCondition = invocationCondition;
            return this;
        }

        public final String getLambdaArn() {
            return this.lambdaArn;
        }

        public final void setLambdaArn(String lambdaArn) {
            this.lambdaArn = lambdaArn;
        }

        @Override
        public final Builder lambdaArn(String lambdaArn) {
            this.lambdaArn = lambdaArn;
            return this;
        }

        public final String getS3Bucket() {
            return this.s3Bucket;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public HookConfiguration build() {
            return new HookConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HookConfiguration> {
        public Builder invocationCondition(DocumentAttributeCondition var1);

        default public Builder invocationCondition(Consumer<DocumentAttributeCondition.Builder> invocationCondition) {
            return this.invocationCondition((DocumentAttributeCondition)((DocumentAttributeCondition.Builder)DocumentAttributeCondition.builder().applyMutation(invocationCondition)).build());
        }

        public Builder lambdaArn(String var1);

        public Builder s3Bucket(String var1);
    }
}

