/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.AssociateEntityListCopier;
import software.amazon.awssdk.services.kendra.model.EntityConfiguration;
import software.amazon.awssdk.services.kendra.model.KendraRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateEntitiesToExperienceRequest
extends KendraRequest
implements ToCopyableBuilder<Builder, AssociateEntitiesToExperienceRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(AssociateEntitiesToExperienceRequest.getter(AssociateEntitiesToExperienceRequest::id)).setter(AssociateEntitiesToExperienceRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> INDEX_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexId").getter(AssociateEntitiesToExperienceRequest.getter(AssociateEntitiesToExperienceRequest::indexId)).setter(AssociateEntitiesToExperienceRequest.setter(Builder::indexId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexId").build()}).build();
    private static final SdkField<List<EntityConfiguration>> ENTITY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EntityList").getter(AssociateEntitiesToExperienceRequest.getter(AssociateEntitiesToExperienceRequest::entityList)).setter(AssociateEntitiesToExperienceRequest.setter(Builder::entityList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EntityConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, INDEX_ID_FIELD, ENTITY_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Id", ID_FIELD);
            this.put("IndexId", INDEX_ID_FIELD);
            this.put("EntityList", ENTITY_LIST_FIELD);
        }
    });
    private final String id;
    private final String indexId;
    private final List<EntityConfiguration> entityList;

    private AssociateEntitiesToExperienceRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.indexId = builder.indexId;
        this.entityList = builder.entityList;
    }

    public final String id() {
        return this.id;
    }

    public final String indexId() {
        return this.indexId;
    }

    public final boolean hasEntityList() {
        return this.entityList != null && !(this.entityList instanceof SdkAutoConstructList);
    }

    public final List<EntityConfiguration> entityList() {
        return this.entityList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntityList() ? this.entityList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateEntitiesToExperienceRequest)) {
            return false;
        }
        AssociateEntitiesToExperienceRequest other = (AssociateEntitiesToExperienceRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.indexId(), other.indexId()) && this.hasEntityList() == other.hasEntityList() && Objects.equals(this.entityList(), other.entityList());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateEntitiesToExperienceRequest").add("Id", (Object)this.id()).add("IndexId", (Object)this.indexId()).add("EntityList", this.hasEntityList() ? this.entityList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "IndexId": {
                return Optional.ofNullable(clazz.cast(this.indexId()));
            }
            case "EntityList": {
                return Optional.ofNullable(clazz.cast(this.entityList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AssociateEntitiesToExperienceRequest, T> g) {
        return obj -> g.apply((AssociateEntitiesToExperienceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KendraRequest.BuilderImpl
    implements Builder {
        private String id;
        private String indexId;
        private List<EntityConfiguration> entityList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateEntitiesToExperienceRequest model) {
            super(model);
            this.id(model.id);
            this.indexId(model.indexId);
            this.entityList(model.entityList);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getIndexId() {
            return this.indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final List<EntityConfiguration.Builder> getEntityList() {
            List<EntityConfiguration.Builder> result = AssociateEntityListCopier.copyToBuilder(this.entityList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntityList(Collection<EntityConfiguration.BuilderImpl> entityList) {
            this.entityList = AssociateEntityListCopier.copyFromBuilder(entityList);
        }

        @Override
        public final Builder entityList(Collection<EntityConfiguration> entityList) {
            this.entityList = AssociateEntityListCopier.copy(entityList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityList(EntityConfiguration ... entityList) {
            this.entityList(Arrays.asList(entityList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityList(Consumer<EntityConfiguration.Builder> ... entityList) {
            this.entityList(Stream.of(entityList).map(c -> (EntityConfiguration)((EntityConfiguration.Builder)EntityConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateEntitiesToExperienceRequest build() {
            return new AssociateEntitiesToExperienceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KendraRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateEntitiesToExperienceRequest> {
        public Builder id(String var1);

        public Builder indexId(String var1);

        public Builder entityList(Collection<EntityConfiguration> var1);

        public Builder entityList(EntityConfiguration ... var1);

        public Builder entityList(Consumer<EntityConfiguration.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

