/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kendra.model.DocumentStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Status
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Status> {
    private static final SdkField<String> DOCUMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentId").getter(Status.getter(Status::documentId)).setter(Status.setter(Builder::documentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentId").build()}).build();
    private static final SdkField<String> DOCUMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentStatus").getter(Status.getter(Status::documentStatusAsString)).setter(Status.setter(Builder::documentStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentStatus").build()}).build();
    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureCode").getter(Status.getter(Status::failureCode)).setter(Status.setter(Builder::failureCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureCode").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(Status.getter(Status::failureReason)).setter(Status.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_ID_FIELD, DOCUMENT_STATUS_FIELD, FAILURE_CODE_FIELD, FAILURE_REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DocumentId", DOCUMENT_ID_FIELD);
            this.put("DocumentStatus", DOCUMENT_STATUS_FIELD);
            this.put("FailureCode", FAILURE_CODE_FIELD);
            this.put("FailureReason", FAILURE_REASON_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String documentId;
    private final String documentStatus;
    private final String failureCode;
    private final String failureReason;

    private Status(BuilderImpl builder) {
        this.documentId = builder.documentId;
        this.documentStatus = builder.documentStatus;
        this.failureCode = builder.failureCode;
        this.failureReason = builder.failureReason;
    }

    public final String documentId() {
        return this.documentId;
    }

    public final DocumentStatus documentStatus() {
        return DocumentStatus.fromValue(this.documentStatus);
    }

    public final String documentStatusAsString() {
        return this.documentStatus;
    }

    public final String failureCode() {
        return this.failureCode;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.documentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Status)) {
            return false;
        }
        Status other = (Status)obj;
        return Objects.equals(this.documentId(), other.documentId()) && Objects.equals(this.documentStatusAsString(), other.documentStatusAsString()) && Objects.equals(this.failureCode(), other.failureCode()) && Objects.equals(this.failureReason(), other.failureReason());
    }

    public final String toString() {
        return ToString.builder((String)"Status").add("DocumentId", (Object)this.documentId()).add("DocumentStatus", (Object)this.documentStatusAsString()).add("FailureCode", (Object)this.failureCode()).add("FailureReason", (Object)this.failureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DocumentId": {
                return Optional.ofNullable(clazz.cast(this.documentId()));
            }
            case "DocumentStatus": {
                return Optional.ofNullable(clazz.cast(this.documentStatusAsString()));
            }
            case "FailureCode": {
                return Optional.ofNullable(clazz.cast(this.failureCode()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Status, T> g) {
        return obj -> g.apply((Status)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String documentId;
        private String documentStatus;
        private String failureCode;
        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(Status model) {
            this.documentId(model.documentId);
            this.documentStatus(model.documentStatus);
            this.failureCode(model.failureCode);
            this.failureReason(model.failureReason);
        }

        public final String getDocumentId() {
            return this.documentId;
        }

        public final void setDocumentId(String documentId) {
            this.documentId = documentId;
        }

        @Override
        public final Builder documentId(String documentId) {
            this.documentId = documentId;
            return this;
        }

        public final String getDocumentStatus() {
            return this.documentStatus;
        }

        public final void setDocumentStatus(String documentStatus) {
            this.documentStatus = documentStatus;
        }

        @Override
        public final Builder documentStatus(String documentStatus) {
            this.documentStatus = documentStatus;
            return this;
        }

        @Override
        public final Builder documentStatus(DocumentStatus documentStatus) {
            this.documentStatus(documentStatus == null ? null : documentStatus.toString());
            return this;
        }

        public final String getFailureCode() {
            return this.failureCode;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public Status build() {
            return new Status(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Status> {
        public Builder documentId(String var1);

        public Builder documentStatus(String var1);

        public Builder documentStatus(DocumentStatus var1);

        public Builder failureCode(String var1);

        public Builder failureReason(String var1);
    }
}

