/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.FaqSummary;
import software.amazon.awssdk.services.kendra.model.FaqSummaryItemsCopier;
import software.amazon.awssdk.services.kendra.model.KendraResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFaqsResponse
extends KendraResponse
implements ToCopyableBuilder<Builder, ListFaqsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListFaqsResponse.getter(ListFaqsResponse::nextToken)).setter(ListFaqsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<FaqSummary>> FAQ_SUMMARY_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FaqSummaryItems").getter(ListFaqsResponse.getter(ListFaqsResponse::faqSummaryItems)).setter(ListFaqsResponse.setter(Builder::faqSummaryItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaqSummaryItems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FaqSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, FAQ_SUMMARY_ITEMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("FaqSummaryItems", FAQ_SUMMARY_ITEMS_FIELD);
        }
    });
    private final String nextToken;
    private final List<FaqSummary> faqSummaryItems;

    private ListFaqsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.faqSummaryItems = builder.faqSummaryItems;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasFaqSummaryItems() {
        return this.faqSummaryItems != null && !(this.faqSummaryItems instanceof SdkAutoConstructList);
    }

    public final List<FaqSummary> faqSummaryItems() {
        return this.faqSummaryItems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFaqSummaryItems() ? this.faqSummaryItems() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFaqsResponse)) {
            return false;
        }
        ListFaqsResponse other = (ListFaqsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasFaqSummaryItems() == other.hasFaqSummaryItems() && Objects.equals(this.faqSummaryItems(), other.faqSummaryItems());
    }

    public final String toString() {
        return ToString.builder((String)"ListFaqsResponse").add("NextToken", (Object)this.nextToken()).add("FaqSummaryItems", this.hasFaqSummaryItems() ? this.faqSummaryItems() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "FaqSummaryItems": {
                return Optional.ofNullable(clazz.cast(this.faqSummaryItems()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListFaqsResponse, T> g) {
        return obj -> g.apply((ListFaqsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KendraResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<FaqSummary> faqSummaryItems = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListFaqsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.faqSummaryItems(model.faqSummaryItems);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<FaqSummary.Builder> getFaqSummaryItems() {
            List<FaqSummary.Builder> result = FaqSummaryItemsCopier.copyToBuilder(this.faqSummaryItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFaqSummaryItems(Collection<FaqSummary.BuilderImpl> faqSummaryItems) {
            this.faqSummaryItems = FaqSummaryItemsCopier.copyFromBuilder(faqSummaryItems);
        }

        @Override
        public final Builder faqSummaryItems(Collection<FaqSummary> faqSummaryItems) {
            this.faqSummaryItems = FaqSummaryItemsCopier.copy(faqSummaryItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faqSummaryItems(FaqSummary ... faqSummaryItems) {
            this.faqSummaryItems(Arrays.asList(faqSummaryItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faqSummaryItems(Consumer<FaqSummary.Builder> ... faqSummaryItems) {
            this.faqSummaryItems(Stream.of(faqSummaryItems).map(c -> (FaqSummary)((FaqSummary.Builder)FaqSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListFaqsResponse build() {
            return new ListFaqsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KendraResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFaqsResponse> {
        public Builder nextToken(String var1);

        public Builder faqSummaryItems(Collection<FaqSummary> var1);

        public Builder faqSummaryItems(FaqSummary ... var1);

        public Builder faqSummaryItems(Consumer<FaqSummary.Builder> ... var1);
    }
}

