/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.kendra.DefaultKendraAsyncClient;
import software.amazon.awssdk.services.kendra.DefaultKendraBaseClientBuilder;
import software.amazon.awssdk.services.kendra.KendraAsyncClient;
import software.amazon.awssdk.services.kendra.KendraAsyncClientBuilder;
import software.amazon.awssdk.services.kendra.KendraServiceClientConfiguration;
import software.amazon.awssdk.services.kendra.endpoints.KendraEndpointProvider;

@SdkInternalApi
final class DefaultKendraAsyncClientBuilder
extends DefaultKendraBaseClientBuilder<KendraAsyncClientBuilder, KendraAsyncClient>
implements KendraAsyncClientBuilder {
    DefaultKendraAsyncClientBuilder() {
    }

    @Override
    public DefaultKendraAsyncClientBuilder endpointProvider(KendraEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final KendraAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultKendraAsyncClientBuilder.validateClientOptions(clientConfiguration);
        KendraServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultKendraAsyncClient client = new DefaultKendraAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private KendraServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return KendraServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

