/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kendra.model.AttributeSuggestionsDescribeConfig;
import software.amazon.awssdk.services.kendra.model.KendraResponse;
import software.amazon.awssdk.services.kendra.model.Mode;
import software.amazon.awssdk.services.kendra.model.QuerySuggestionsStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeQuerySuggestionsConfigResponse
extends KendraResponse
implements ToCopyableBuilder<Builder, DescribeQuerySuggestionsConfigResponse> {
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Mode").getter(DescribeQuerySuggestionsConfigResponse.getter(DescribeQuerySuggestionsConfigResponse::modeAsString)).setter(DescribeQuerySuggestionsConfigResponse.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeQuerySuggestionsConfigResponse.getter(DescribeQuerySuggestionsConfigResponse::statusAsString)).setter(DescribeQuerySuggestionsConfigResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Integer> QUERY_LOG_LOOK_BACK_WINDOW_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("QueryLogLookBackWindowInDays").getter(DescribeQuerySuggestionsConfigResponse.getter(DescribeQuerySuggestionsConfigResponse::queryLogLookBackWindowInDays)).setter(DescribeQuerySuggestionsConfigResponse.setter(Builder::queryLogLookBackWindowInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryLogLookBackWindowInDays").build()}).build();
    private static final SdkField<Boolean> INCLUDE_QUERIES_WITHOUT_USER_INFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeQueriesWithoutUserInformation").getter(DescribeQuerySuggestionsConfigResponse.getter(DescribeQuerySuggestionsConfigResponse::includeQueriesWithoutUserInformation)).setter(DescribeQuerySuggestionsConfigResponse.setter(Builder::includeQueriesWithoutUserInformation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeQueriesWithoutUserInformation").build()}).build();
    private static final SdkField<Integer> MINIMUM_NUMBER_OF_QUERYING_USERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinimumNumberOfQueryingUsers").getter(DescribeQuerySuggestionsConfigResponse.getter(DescribeQuerySuggestionsConfigResponse::minimumNumberOfQueryingUsers)).setter(DescribeQuerySuggestionsConfigResponse.setter(Builder::minimumNumberOfQueryingUsers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumNumberOfQueryingUsers").build()}).build();
    private static final SdkField<Integer> MINIMUM_QUERY_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinimumQueryCount").getter(DescribeQuerySuggestionsConfigResponse.getter(DescribeQuerySuggestionsConfigResponse::minimumQueryCount)).setter(DescribeQuerySuggestionsConfigResponse.setter(Builder::minimumQueryCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumQueryCount").build()}).build();
    private static final SdkField<Instant> LAST_SUGGESTIONS_BUILD_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastSuggestionsBuildTime").getter(DescribeQuerySuggestionsConfigResponse.getter(DescribeQuerySuggestionsConfigResponse::lastSuggestionsBuildTime)).setter(DescribeQuerySuggestionsConfigResponse.setter(Builder::lastSuggestionsBuildTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSuggestionsBuildTime").build()}).build();
    private static final SdkField<Instant> LAST_CLEAR_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastClearTime").getter(DescribeQuerySuggestionsConfigResponse.getter(DescribeQuerySuggestionsConfigResponse::lastClearTime)).setter(DescribeQuerySuggestionsConfigResponse.setter(Builder::lastClearTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastClearTime").build()}).build();
    private static final SdkField<Integer> TOTAL_SUGGESTIONS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalSuggestionsCount").getter(DescribeQuerySuggestionsConfigResponse.getter(DescribeQuerySuggestionsConfigResponse::totalSuggestionsCount)).setter(DescribeQuerySuggestionsConfigResponse.setter(Builder::totalSuggestionsCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalSuggestionsCount").build()}).build();
    private static final SdkField<AttributeSuggestionsDescribeConfig> ATTRIBUTE_SUGGESTIONS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AttributeSuggestionsConfig").getter(DescribeQuerySuggestionsConfigResponse.getter(DescribeQuerySuggestionsConfigResponse::attributeSuggestionsConfig)).setter(DescribeQuerySuggestionsConfigResponse.setter(Builder::attributeSuggestionsConfig)).constructor(AttributeSuggestionsDescribeConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeSuggestionsConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODE_FIELD, STATUS_FIELD, QUERY_LOG_LOOK_BACK_WINDOW_IN_DAYS_FIELD, INCLUDE_QUERIES_WITHOUT_USER_INFORMATION_FIELD, MINIMUM_NUMBER_OF_QUERYING_USERS_FIELD, MINIMUM_QUERY_COUNT_FIELD, LAST_SUGGESTIONS_BUILD_TIME_FIELD, LAST_CLEAR_TIME_FIELD, TOTAL_SUGGESTIONS_COUNT_FIELD, ATTRIBUTE_SUGGESTIONS_CONFIG_FIELD));
    private final String mode;
    private final String status;
    private final Integer queryLogLookBackWindowInDays;
    private final Boolean includeQueriesWithoutUserInformation;
    private final Integer minimumNumberOfQueryingUsers;
    private final Integer minimumQueryCount;
    private final Instant lastSuggestionsBuildTime;
    private final Instant lastClearTime;
    private final Integer totalSuggestionsCount;
    private final AttributeSuggestionsDescribeConfig attributeSuggestionsConfig;

    private DescribeQuerySuggestionsConfigResponse(BuilderImpl builder) {
        super(builder);
        this.mode = builder.mode;
        this.status = builder.status;
        this.queryLogLookBackWindowInDays = builder.queryLogLookBackWindowInDays;
        this.includeQueriesWithoutUserInformation = builder.includeQueriesWithoutUserInformation;
        this.minimumNumberOfQueryingUsers = builder.minimumNumberOfQueryingUsers;
        this.minimumQueryCount = builder.minimumQueryCount;
        this.lastSuggestionsBuildTime = builder.lastSuggestionsBuildTime;
        this.lastClearTime = builder.lastClearTime;
        this.totalSuggestionsCount = builder.totalSuggestionsCount;
        this.attributeSuggestionsConfig = builder.attributeSuggestionsConfig;
    }

    public final Mode mode() {
        return Mode.fromValue(this.mode);
    }

    public final String modeAsString() {
        return this.mode;
    }

    public final QuerySuggestionsStatus status() {
        return QuerySuggestionsStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Integer queryLogLookBackWindowInDays() {
        return this.queryLogLookBackWindowInDays;
    }

    public final Boolean includeQueriesWithoutUserInformation() {
        return this.includeQueriesWithoutUserInformation;
    }

    public final Integer minimumNumberOfQueryingUsers() {
        return this.minimumNumberOfQueryingUsers;
    }

    public final Integer minimumQueryCount() {
        return this.minimumQueryCount;
    }

    public final Instant lastSuggestionsBuildTime() {
        return this.lastSuggestionsBuildTime;
    }

    public final Instant lastClearTime() {
        return this.lastClearTime;
    }

    public final Integer totalSuggestionsCount() {
        return this.totalSuggestionsCount;
    }

    public final AttributeSuggestionsDescribeConfig attributeSuggestionsConfig() {
        return this.attributeSuggestionsConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryLogLookBackWindowInDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeQueriesWithoutUserInformation());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumNumberOfQueryingUsers());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumQueryCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSuggestionsBuildTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastClearTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalSuggestionsCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeSuggestionsConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeQuerySuggestionsConfigResponse)) {
            return false;
        }
        DescribeQuerySuggestionsConfigResponse other = (DescribeQuerySuggestionsConfigResponse)((Object)obj);
        return Objects.equals(this.modeAsString(), other.modeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.queryLogLookBackWindowInDays(), other.queryLogLookBackWindowInDays()) && Objects.equals(this.includeQueriesWithoutUserInformation(), other.includeQueriesWithoutUserInformation()) && Objects.equals(this.minimumNumberOfQueryingUsers(), other.minimumNumberOfQueryingUsers()) && Objects.equals(this.minimumQueryCount(), other.minimumQueryCount()) && Objects.equals(this.lastSuggestionsBuildTime(), other.lastSuggestionsBuildTime()) && Objects.equals(this.lastClearTime(), other.lastClearTime()) && Objects.equals(this.totalSuggestionsCount(), other.totalSuggestionsCount()) && Objects.equals(this.attributeSuggestionsConfig(), other.attributeSuggestionsConfig());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeQuerySuggestionsConfigResponse").add("Mode", (Object)this.modeAsString()).add("Status", (Object)this.statusAsString()).add("QueryLogLookBackWindowInDays", (Object)this.queryLogLookBackWindowInDays()).add("IncludeQueriesWithoutUserInformation", (Object)this.includeQueriesWithoutUserInformation()).add("MinimumNumberOfQueryingUsers", (Object)this.minimumNumberOfQueryingUsers()).add("MinimumQueryCount", (Object)this.minimumQueryCount()).add("LastSuggestionsBuildTime", (Object)this.lastSuggestionsBuildTime()).add("LastClearTime", (Object)this.lastClearTime()).add("TotalSuggestionsCount", (Object)this.totalSuggestionsCount()).add("AttributeSuggestionsConfig", (Object)this.attributeSuggestionsConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "QueryLogLookBackWindowInDays": {
                return Optional.ofNullable(clazz.cast(this.queryLogLookBackWindowInDays()));
            }
            case "IncludeQueriesWithoutUserInformation": {
                return Optional.ofNullable(clazz.cast(this.includeQueriesWithoutUserInformation()));
            }
            case "MinimumNumberOfQueryingUsers": {
                return Optional.ofNullable(clazz.cast(this.minimumNumberOfQueryingUsers()));
            }
            case "MinimumQueryCount": {
                return Optional.ofNullable(clazz.cast(this.minimumQueryCount()));
            }
            case "LastSuggestionsBuildTime": {
                return Optional.ofNullable(clazz.cast(this.lastSuggestionsBuildTime()));
            }
            case "LastClearTime": {
                return Optional.ofNullable(clazz.cast(this.lastClearTime()));
            }
            case "TotalSuggestionsCount": {
                return Optional.ofNullable(clazz.cast(this.totalSuggestionsCount()));
            }
            case "AttributeSuggestionsConfig": {
                return Optional.ofNullable(clazz.cast(this.attributeSuggestionsConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeQuerySuggestionsConfigResponse, T> g) {
        return obj -> g.apply((DescribeQuerySuggestionsConfigResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KendraResponse.BuilderImpl
    implements Builder {
        private String mode;
        private String status;
        private Integer queryLogLookBackWindowInDays;
        private Boolean includeQueriesWithoutUserInformation;
        private Integer minimumNumberOfQueryingUsers;
        private Integer minimumQueryCount;
        private Instant lastSuggestionsBuildTime;
        private Instant lastClearTime;
        private Integer totalSuggestionsCount;
        private AttributeSuggestionsDescribeConfig attributeSuggestionsConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeQuerySuggestionsConfigResponse model) {
            super(model);
            this.mode(model.mode);
            this.status(model.status);
            this.queryLogLookBackWindowInDays(model.queryLogLookBackWindowInDays);
            this.includeQueriesWithoutUserInformation(model.includeQueriesWithoutUserInformation);
            this.minimumNumberOfQueryingUsers(model.minimumNumberOfQueryingUsers);
            this.minimumQueryCount(model.minimumQueryCount);
            this.lastSuggestionsBuildTime(model.lastSuggestionsBuildTime);
            this.lastClearTime(model.lastClearTime);
            this.totalSuggestionsCount(model.totalSuggestionsCount);
            this.attributeSuggestionsConfig(model.attributeSuggestionsConfig);
        }

        public final String getMode() {
            return this.mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(Mode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(QuerySuggestionsStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Integer getQueryLogLookBackWindowInDays() {
            return this.queryLogLookBackWindowInDays;
        }

        public final void setQueryLogLookBackWindowInDays(Integer queryLogLookBackWindowInDays) {
            this.queryLogLookBackWindowInDays = queryLogLookBackWindowInDays;
        }

        @Override
        public final Builder queryLogLookBackWindowInDays(Integer queryLogLookBackWindowInDays) {
            this.queryLogLookBackWindowInDays = queryLogLookBackWindowInDays;
            return this;
        }

        public final Boolean getIncludeQueriesWithoutUserInformation() {
            return this.includeQueriesWithoutUserInformation;
        }

        public final void setIncludeQueriesWithoutUserInformation(Boolean includeQueriesWithoutUserInformation) {
            this.includeQueriesWithoutUserInformation = includeQueriesWithoutUserInformation;
        }

        @Override
        public final Builder includeQueriesWithoutUserInformation(Boolean includeQueriesWithoutUserInformation) {
            this.includeQueriesWithoutUserInformation = includeQueriesWithoutUserInformation;
            return this;
        }

        public final Integer getMinimumNumberOfQueryingUsers() {
            return this.minimumNumberOfQueryingUsers;
        }

        public final void setMinimumNumberOfQueryingUsers(Integer minimumNumberOfQueryingUsers) {
            this.minimumNumberOfQueryingUsers = minimumNumberOfQueryingUsers;
        }

        @Override
        public final Builder minimumNumberOfQueryingUsers(Integer minimumNumberOfQueryingUsers) {
            this.minimumNumberOfQueryingUsers = minimumNumberOfQueryingUsers;
            return this;
        }

        public final Integer getMinimumQueryCount() {
            return this.minimumQueryCount;
        }

        public final void setMinimumQueryCount(Integer minimumQueryCount) {
            this.minimumQueryCount = minimumQueryCount;
        }

        @Override
        public final Builder minimumQueryCount(Integer minimumQueryCount) {
            this.minimumQueryCount = minimumQueryCount;
            return this;
        }

        public final Instant getLastSuggestionsBuildTime() {
            return this.lastSuggestionsBuildTime;
        }

        public final void setLastSuggestionsBuildTime(Instant lastSuggestionsBuildTime) {
            this.lastSuggestionsBuildTime = lastSuggestionsBuildTime;
        }

        @Override
        public final Builder lastSuggestionsBuildTime(Instant lastSuggestionsBuildTime) {
            this.lastSuggestionsBuildTime = lastSuggestionsBuildTime;
            return this;
        }

        public final Instant getLastClearTime() {
            return this.lastClearTime;
        }

        public final void setLastClearTime(Instant lastClearTime) {
            this.lastClearTime = lastClearTime;
        }

        @Override
        public final Builder lastClearTime(Instant lastClearTime) {
            this.lastClearTime = lastClearTime;
            return this;
        }

        public final Integer getTotalSuggestionsCount() {
            return this.totalSuggestionsCount;
        }

        public final void setTotalSuggestionsCount(Integer totalSuggestionsCount) {
            this.totalSuggestionsCount = totalSuggestionsCount;
        }

        @Override
        public final Builder totalSuggestionsCount(Integer totalSuggestionsCount) {
            this.totalSuggestionsCount = totalSuggestionsCount;
            return this;
        }

        public final AttributeSuggestionsDescribeConfig.Builder getAttributeSuggestionsConfig() {
            return this.attributeSuggestionsConfig != null ? this.attributeSuggestionsConfig.toBuilder() : null;
        }

        public final void setAttributeSuggestionsConfig(AttributeSuggestionsDescribeConfig.BuilderImpl attributeSuggestionsConfig) {
            this.attributeSuggestionsConfig = attributeSuggestionsConfig != null ? attributeSuggestionsConfig.build() : null;
        }

        @Override
        public final Builder attributeSuggestionsConfig(AttributeSuggestionsDescribeConfig attributeSuggestionsConfig) {
            this.attributeSuggestionsConfig = attributeSuggestionsConfig;
            return this;
        }

        @Override
        public DescribeQuerySuggestionsConfigResponse build() {
            return new DescribeQuerySuggestionsConfigResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KendraResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeQuerySuggestionsConfigResponse> {
        public Builder mode(String var1);

        public Builder mode(Mode var1);

        public Builder status(String var1);

        public Builder status(QuerySuggestionsStatus var1);

        public Builder queryLogLookBackWindowInDays(Integer var1);

        public Builder includeQueriesWithoutUserInformation(Boolean var1);

        public Builder minimumNumberOfQueryingUsers(Integer var1);

        public Builder minimumQueryCount(Integer var1);

        public Builder lastSuggestionsBuildTime(Instant var1);

        public Builder lastClearTime(Instant var1);

        public Builder totalSuggestionsCount(Integer var1);

        public Builder attributeSuggestionsConfig(AttributeSuggestionsDescribeConfig var1);

        default public Builder attributeSuggestionsConfig(Consumer<AttributeSuggestionsDescribeConfig.Builder> attributeSuggestionsConfig) {
            return this.attributeSuggestionsConfig((AttributeSuggestionsDescribeConfig)((AttributeSuggestionsDescribeConfig.Builder)AttributeSuggestionsDescribeConfig.builder().applyMutation(attributeSuggestionsConfig)).build());
        }
    }
}

