/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SuggestableConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SuggestableConfig> {
    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttributeName").getter(SuggestableConfig.getter(SuggestableConfig::attributeName)).setter(SuggestableConfig.setter(Builder::attributeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeName").build()}).build();
    private static final SdkField<Boolean> SUGGESTABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Suggestable").getter(SuggestableConfig.getter(SuggestableConfig::suggestable)).setter(SuggestableConfig.setter(Builder::suggestable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Suggestable").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_NAME_FIELD, SUGGESTABLE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String attributeName;
    private final Boolean suggestable;

    private SuggestableConfig(BuilderImpl builder) {
        this.attributeName = builder.attributeName;
        this.suggestable = builder.suggestable;
    }

    public final String attributeName() {
        return this.attributeName;
    }

    public final Boolean suggestable() {
        return this.suggestable;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.suggestable());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuggestableConfig)) {
            return false;
        }
        SuggestableConfig other = (SuggestableConfig)obj;
        return Objects.equals(this.attributeName(), other.attributeName()) && Objects.equals(this.suggestable(), other.suggestable());
    }

    public final String toString() {
        return ToString.builder((String)"SuggestableConfig").add("AttributeName", (Object)this.attributeName()).add("Suggestable", (Object)this.suggestable()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttributeName": {
                return Optional.ofNullable(clazz.cast(this.attributeName()));
            }
            case "Suggestable": {
                return Optional.ofNullable(clazz.cast(this.suggestable()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SuggestableConfig, T> g) {
        return obj -> g.apply((SuggestableConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String attributeName;
        private Boolean suggestable;

        private BuilderImpl() {
        }

        private BuilderImpl(SuggestableConfig model) {
            this.attributeName(model.attributeName);
            this.suggestable(model.suggestable);
        }

        public final String getAttributeName() {
            return this.attributeName;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final Boolean getSuggestable() {
            return this.suggestable;
        }

        public final void setSuggestable(Boolean suggestable) {
            this.suggestable = suggestable;
        }

        @Override
        public final Builder suggestable(Boolean suggestable) {
            this.suggestable = suggestable;
            return this;
        }

        public SuggestableConfig build() {
            return new SuggestableConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SuggestableConfig> {
        public Builder attributeName(String var1);

        public Builder suggestable(Boolean var1);
    }
}

