/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the configuration information to get users and groups from an IAM Identity Center (successor to Single
 * Sign-On) identity source. This is useful for user context filtering, where search results are filtered based on the
 * user or their group access to documents. You can also use the <a
 * href="https://docs.aws.amazon.com/kendra/latest/dg/API_PutPrincipalMapping.html">PutPrincipalMapping</a> API to map
 * users to their groups so that you only need to provide the user ID when you issue the query.
 * </p>
 * <p>
 * To set up an IAM Identity Center identity source in the console to use with Amazon Kendra, see <a
 * href="https://docs.aws.amazon.com/kendra/latest/dg/getting-started-aws-sso.html">Getting started with an IAM Identity
 * Center identity source</a>. You must also grant the required permissions to use IAM Identity Center with Amazon
 * Kendra. For more information, see <a
 * href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html#iam-roles-aws-sso">IAM roles for IAM Identity
 * Center</a>.
 * </p>
 * <p>
 * Amazon Kendra currently does not support using <code>UserGroupResolutionConfiguration</code> with an Amazon Web
 * Services organization member account for your IAM Identity Center identify source. You must create your index in the
 * management account for the organization in order to use <code>UserGroupResolutionConfiguration</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserGroupResolutionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<UserGroupResolutionConfiguration.Builder, UserGroupResolutionConfiguration> {
    private static final SdkField<String> USER_GROUP_RESOLUTION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserGroupResolutionMode")
            .getter(getter(UserGroupResolutionConfiguration::userGroupResolutionModeAsString))
            .setter(setter(Builder::userGroupResolutionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserGroupResolutionMode").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(USER_GROUP_RESOLUTION_MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String userGroupResolutionMode;

    private UserGroupResolutionConfiguration(BuilderImpl builder) {
        this.userGroupResolutionMode = builder.userGroupResolutionMode;
    }

    /**
     * <p>
     * The identity store provider (mode) you want to use to get users and groups. IAM Identity Center (successor to
     * Single Sign-On) is currently the only available mode. Your users and groups must exist in an IAM Identity Center
     * identity source in order to use this mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #userGroupResolutionMode} will return {@link UserGroupResolutionMode#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #userGroupResolutionModeAsString}.
     * </p>
     * 
     * @return The identity store provider (mode) you want to use to get users and groups. IAM Identity Center
     *         (successor to Single Sign-On) is currently the only available mode. Your users and groups must exist in
     *         an IAM Identity Center identity source in order to use this mode.
     * @see UserGroupResolutionMode
     */
    public final UserGroupResolutionMode userGroupResolutionMode() {
        return UserGroupResolutionMode.fromValue(userGroupResolutionMode);
    }

    /**
     * <p>
     * The identity store provider (mode) you want to use to get users and groups. IAM Identity Center (successor to
     * Single Sign-On) is currently the only available mode. Your users and groups must exist in an IAM Identity Center
     * identity source in order to use this mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #userGroupResolutionMode} will return {@link UserGroupResolutionMode#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #userGroupResolutionModeAsString}.
     * </p>
     * 
     * @return The identity store provider (mode) you want to use to get users and groups. IAM Identity Center
     *         (successor to Single Sign-On) is currently the only available mode. Your users and groups must exist in
     *         an IAM Identity Center identity source in order to use this mode.
     * @see UserGroupResolutionMode
     */
    public final String userGroupResolutionModeAsString() {
        return userGroupResolutionMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userGroupResolutionModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserGroupResolutionConfiguration)) {
            return false;
        }
        UserGroupResolutionConfiguration other = (UserGroupResolutionConfiguration) obj;
        return Objects.equals(userGroupResolutionModeAsString(), other.userGroupResolutionModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UserGroupResolutionConfiguration")
                .add("UserGroupResolutionMode", userGroupResolutionModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserGroupResolutionMode":
            return Optional.ofNullable(clazz.cast(userGroupResolutionModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserGroupResolutionConfiguration, T> g) {
        return obj -> g.apply((UserGroupResolutionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserGroupResolutionConfiguration> {
        /**
         * <p>
         * The identity store provider (mode) you want to use to get users and groups. IAM Identity Center (successor to
         * Single Sign-On) is currently the only available mode. Your users and groups must exist in an IAM Identity
         * Center identity source in order to use this mode.
         * </p>
         * 
         * @param userGroupResolutionMode
         *        The identity store provider (mode) you want to use to get users and groups. IAM Identity Center
         *        (successor to Single Sign-On) is currently the only available mode. Your users and groups must exist
         *        in an IAM Identity Center identity source in order to use this mode.
         * @see UserGroupResolutionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserGroupResolutionMode
         */
        Builder userGroupResolutionMode(String userGroupResolutionMode);

        /**
         * <p>
         * The identity store provider (mode) you want to use to get users and groups. IAM Identity Center (successor to
         * Single Sign-On) is currently the only available mode. Your users and groups must exist in an IAM Identity
         * Center identity source in order to use this mode.
         * </p>
         * 
         * @param userGroupResolutionMode
         *        The identity store provider (mode) you want to use to get users and groups. IAM Identity Center
         *        (successor to Single Sign-On) is currently the only available mode. Your users and groups must exist
         *        in an IAM Identity Center identity source in order to use this mode.
         * @see UserGroupResolutionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserGroupResolutionMode
         */
        Builder userGroupResolutionMode(UserGroupResolutionMode userGroupResolutionMode);
    }

    static final class BuilderImpl implements Builder {
        private String userGroupResolutionMode;

        private BuilderImpl() {
        }

        private BuilderImpl(UserGroupResolutionConfiguration model) {
            userGroupResolutionMode(model.userGroupResolutionMode);
        }

        public final String getUserGroupResolutionMode() {
            return userGroupResolutionMode;
        }

        public final void setUserGroupResolutionMode(String userGroupResolutionMode) {
            this.userGroupResolutionMode = userGroupResolutionMode;
        }

        @Override
        public final Builder userGroupResolutionMode(String userGroupResolutionMode) {
            this.userGroupResolutionMode = userGroupResolutionMode;
            return this;
        }

        @Override
        public final Builder userGroupResolutionMode(UserGroupResolutionMode userGroupResolutionMode) {
            this.userGroupResolutionMode(userGroupResolutionMode == null ? null : userGroupResolutionMode.toString());
            return this;
        }

        @Override
        public UserGroupResolutionConfiguration build() {
            return new UserGroupResolutionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
